% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertKMToDeg.R
\name{convertKMToDeg}
\alias{convertKMToDeg}
\title{Converts a set of coordinates in The Universal Transverse Mercator (UTM) zone:37 coordinate system into a new set of coordinates in degrees.}
\usage{
convertKMToDeg(loc)
}
\arguments{
\item{loc}{A two column matrix of coordinates in The Universal Transverse Mercator (UTM) zone:37 coordinate system (https://www.usgs.gov/faqs/what-does-term-utm-mean-utm-better-or-more-accurate-latitudelongitude).}
}
\value{
A two column matrix of coordinates in degrees (the first column is longitude and the second column is latitude).
}
\description{
Converts a set of coordinates in The Universal Transverse Mercator (UTM) zone:37 coordinate system into a new set of coordinates in degrees.
}
\examples{
path1 <- system.file("extdata", "geoData.rda", package = "GeoAdjust")
load(path1)
locKM <- cbind(surveyData$east, surveyData$north)
locDegree <- convertKMToDeg(loc = locKM)
head(locDegree)
}
