% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dgrp2.3R.5k.data}
\alias{dgrp2.3R.5k.data}
\title{A subset of sequencing data from the Drosophila Genetics Reference Panel}
\format{
genomeadmixr_data object
}
\usage{
data("dgrp2.3R.5k.data")
}
\description{
This data set contains sequences from the 3R chromosome.
Included are 4603 SNPs with at least 0.05 minor allele frequency,  sequenced
across 410 isofemale lines. Sequences were downloaded from
<http://dgrp2.gnets.ncsu.edu/data.html>.
}
\examples{
data("dgrp2.3R.5k.data")
simulate_admixture(
       module = sequence_module(molecular_data = dgrp2.3R.5k.data),
       pop_size = 100,
       total_runtime = 10)
}
\references{
Mackay, T., Richards, S., Stone, E. et al. The Drosophila
melanogaster Genetic Reference Panel. Nature 482, 173–178 (2012).
<https://doi.org/10.1038/nature10811>
}
\keyword{datasets}
