% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{runGSEA}
\alias{runGSEA}
\title{Run Gene set enrichment analysis}
\usage{
runGSEA(
  genes,
  universe = NULL,
  category = "H",
  subcategory = NULL,
  species = "Homo sapiens",
  pval.thr = 0.05
)
}
\arguments{
\item{genes}{A vector of genes}

\item{universe}{Background universe of gene symbols (passed on to \code{fgsea::fora})}

\item{category}{GSEA main category (e.g. "H" or "C5")}

\item{subcategory}{GSEA subcategory}

\item{species}{Species for GSEA analysis. For a list of the available species,
type \code{msigdbr::msigdbr_species()}}

\item{pval.thr}{Min p-value to include results}
}
\value{
Returns a table of enriched gene programs from GSEA
}
\description{
Utility function to run Gene set enrichment analysis (GSEA) against gene 
sets from MSigDB.
}
\examples{
data(sampleObj)
geneset <- c("BANK1","CD22","CD79A","CD19","IGHD","IGHG3","IGHM")
gsea_res <- runGSEA(geneset, universe=rownames(sampleObj), category = "C8")

}
