% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{load_file}
\alias{load_file}
\title{Load a GTF or GFF3 file from GENCODE as a data frame.}
\usage{
load_file(filename)
}
\arguments{
\item{filename}{A character string representing the path to the GTF or GFF3 file (e.g., "gencode.vM36.annotation.gtf.gz").
The file could be in GTF or GFF3 format and must be downloaded from a reliable source like GENCODE.}
}
\value{
A data frame containing the parsed content of the GTF or GFF3 file.
The data frame includes standard columns such as 'seqnames', 'start', 'end', 'strand', 'feature', and 'gene_id', among others.
}
\description{
This function imports a GTF or GFF3 file (commonly from the GENCODE website) and converts it into a data frame.
The function provides flexibility for users to work with genomic feature files easily in the R environment.
}
\details{
The function uses the \code{rtracklayer} package to import the GTF or GFF3 file and returns it as a data frame.
The user should ensure that the input file is properly formatted and accessible from the specified path.
Files larger than a few hundred MBs may take longer to load and process.
}
\examples{
# Load example GTF files from the package
file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
gtf_v1 <- load_file(file_v1)
head(gtf_v1)

}
