% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getSizeMean}
\alias{getSizeMean}
\alias{getSizeProp}
\alias{getSizeTTE}
\alias{getSizeOrd}
\title{General Formulas for Sample Size Calculation}
\usage{
getSizeMean(
  design = c("parallel", "crossover"),
  test = c("equality", "noninferiority", "superiority", "equivalence"),
  alpha = 0.05,
  beta = 0.2,
  sigma,
  k = 1,
  delta = 0,
  TTE,
  rho = c(0.05, 0.07),
  r = 0.1
)

getSizeProp(
  design = c("parallel", "crossover"),
  test = c("equality", "noninferiority", "superiority", "equivalence"),
  alpha = 0.05,
  beta = 0.2,
  varsigma,
  k = 1,
  seqnumber,
  delta = 0,
  TTE,
  rho = c(0.05, 0.07),
  r = 0.1
)

getSizeTTE(
  design = c("parallel", "crossover"),
  test = c("equality", "noninferiority", "superiority", "equivalence"),
  alpha = 0.05,
  beta = 0.2,
  varlambda,
  k = 1,
  ttotal,
  taccrual,
  gamma,
  delta = 0,
  rho = c(0.05, 0.07),
  r = 0.1
)

getSizeOrd(
  design = c("parallel", "crossover"),
  test = c("equality", "noninferiority", "superiority", "equivalence"),
  alpha = 0.05,
  beta = 0.2,
  varcatprob,
  k = 1,
  theta,
  delta = 0,
  rho = c(0.05, 0.07),
  r = 0.1
)
}
\arguments{
\item{design}{allocation method (\code{parallel} or \code{crossover}).}

\item{test}{four hypothesis tests: \code{equality}, \code{noninferiority}, \code{superiority}, and \code{equivalence}.}

\item{alpha}{level of significance.}

\item{beta}{type II error.}

\item{sigma}{pooled standard deviation of two groups.}

\item{k}{ratio of control to treatment.}

\item{delta}{delta margin in test hypothesis.}

\item{TTE}{target treatment effect or effect size.}

\item{rho}{vector of length 2, positive noncompliance rates of two arms.}

\item{r}{projected proportion of trial uniform loss of follow-up.}

\item{varsigma}{(varsigma1 > 0, varsigma2 > 0) := (p1, p2) probability of mean response in control and treatment arms; (\code{varsigma1} > 0, \code{varsigma2} > 0) := (\code{sigma}, \code{sigma}) pooled standard deviation of two groups or their difference (sigma>0)}

\item{seqnumber}{Number of crossover sequences: 0 if parallel; 1+ if crossover (seqnumber>=0)}

\item{varlambda}{(varlambda1>0,varlambda2>0):=(lam1,lam2) hazard rates in control and treatment arms}

\item{ttotal}{total trial time(ttoal>0)}

\item{taccrual}{accrual time period (taccrual>0)}

\item{gamma}{parameter of exponential distribution(gamma>=0)}

\item{varcatprob}{list of two probability vectors per treatment arm}

\item{theta}{log odds ratio of outcome in treatment arm versus control arm}
}
\value{
sample size per arm.
}
\description{
This function computes the sample size required for two arms clinical trials with continuous (\code{getSizeMean}), binary (\code{getSizeProp}), TTE (\code{getSizeTTE}), and ordinal outcome measure (\code{getSizeOrd}). Four hypothesis tests are available under two allocation designs.
}
\examples{
# Ex 1. (n_trt=91, n_ctl=91)
getSizeMean(design="parallel", test="equality", alpha=0.05, beta=0.20,
  sigma=0.10, k=1, delta=0, TTE=0.05, rho=c(0.05, 0.07), r=0.1)

getSizeMean(design="parallel", test="noninferiority", alpha=0.05,
 beta=0.20, sigma=0.10, k=1, delta=-0.05, TTE=0, rho=c(0.05, 0.07), r=0.1)

# Ex 3. (n_trt=1022, n_ctl=1022)
getSizeMean(design="parallel", test="superiority", alpha=0.05, beta=0.20,
  sigma=0.10, k=1, delta=0.05, TTE=0.07, rho=c(0.05, 0.07), r=0.1)

# Ex 4. (n_trt=113, n_ctl=113)
getSizeMean(design="parallel", test="equivalence", alpha=0.05, beta=0.20,
  sigma=0.10, k=1, delta=0.05, TTE=0.01, rho=c(0.05, 0.07), r=0.1)

# Ex 5. (n_trt=23, n_ctl=23)
getSizeMean(design="crossover", test="equality", alpha=0.05, beta=0.20,
 sigma=0.10, k=1, delta=0, TTE=0.05, rho=c(0.05, 0.07), r=0.1)

# Ex 6. (n_trt=14, n_ctl=14)
getSizeMean(design="crossover", test="noninferiority", alpha=0.05,
 beta=0.20, sigma=0.10, k=1, delta=-0.05, TTE=0, rho=c(0.05, 0.07), r=0.1)

# Ex 7. (n_trt=21, n_ctl=21)
getSizeMean(design="crossover", test="superiority", alpha=0.05, beta=0.20,
 sigma=0.10, k=1, delta=0.05, TTE=0.01, rho=c(0.05, 0.07), r=0.1)

# Ex 8. (n_trt=29, n_ctl=29)
getSizeMean(design="crossover", test="equivalence", alpha=0.05, beta=0.20,
 sigma=0.10, k=1, delta=0.05, TTE=0.01, rho=c(0.05, 0.07), r=0.1)

# Ex 1. (n_trt=102, n_ctl=102)
getSizeProp(design="parallel", test="equality", alpha=0.05, beta=0.20,
 varsigma=c(0.65, 0.85), k=1, seqnumber=0, delta=0, TTE=0,
 rho=c(0.05, 0.07), r=0.1)

# Ex 2. (n_trt=33, n_ctl=33)
getSizeProp(design="parallel", test="noninferiority", alpha=0.05, beta=0.20,
 varsigma=c(0.65,0.85), k=1, seqnumber=0, delta=-0.10, TTE=0.20,
 rho=c(0.05, 0.07), r=0.1)

# Ex 3. (n_trt=157, n_ctl=157)
getSizeProp(design="parallel", test="superiority", alpha=0.05, beta=0.20,
 varsigma=c(0.65,0.85), k=1, seqnumber=0, delta=0.05, TTE=0.20,
 rho=c(0.05, 0.07), r=0.1)

# Ex 4. (n_trt=137, n_ctl=137)
getSizeProp(design="parallel", test="equivalence", alpha=0.05, beta=0.20,
 varsigma=c(0.75,0.80), k=1, seqnumber=0, delta=0.20, TTE=0.05,
 rho=c(0.05, 0.07), r=0.1)

# Ex 5. (n_trt=36, n_ctl=36)
getSizeProp(design="crossover", test="equality", alpha=0.05, beta=0.20,
 varsigma=c(0.5,0.5), k=1, seqnumber=2, delta=0, TTE=0.20,
 rho=c(0.05, 0.07), r=0.1)

# Ex 6. (n_trt=22, n_ctl=22)
getSizeProp(design="crossover", test="noninferiority", alpha=0.05,
 beta=0.20, varsigma=c(0.5,0.5), k=1, seqnumber=2, delta=-0.20, TTE=0,
 rho=c(0.05, 0.07), r=0.1)

# Ex 7. (n_trt=86, n_ctl=86)
getSizeProp(design="crossover", test="superiority", alpha=0.05, beta=0.20,
 varsigma=c(0.5,0.5), k=1, seqnumber=2, delta=0.10, TTE=0,
 rho=c(0.05, 0.07), r=0.1)

# Ex 8. (n_trt=30, n_ctl=30)
getSizeProp(design="crossover", test="equivalence", alpha=0.05, beta=0.20,
 varsigma=c(0.5,0.5), k=1, seqnumber=2, delta=0.20, TTE=0,
 rho=c(0.05, 0.07), r=0.1)
# Ex 1. (n_trt=56, n_ctl=56)
getSizeTTE(design="parallel", test="equality", alpha=0.05, beta=0.20,
 varlambda=c(1,2), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0,
 rho=c(0.05, 0.07), r=0.1)

# Ex 2. (n_trt=30, n_ctl=30)
getSizeTTE(design="parallel", test="noninferiority", alpha=0.05, beta=0.20,
 varlambda=c(1,2), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta= -0.2,
 rho=c(0.05, 0.07), r=0.1)

# Ex 3. (n_trt=74, n_ctl=74)
getSizeTTE(design="parallel", test="superiority", alpha=0.05, beta=0.20,
varlambda=c(1,2), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0.20,
rho=c(0.05, 0.07), r=0.1)

# Ex 4. (n_trt=84, n_ctl=84)
getSizeTTE(design="parallel", test="equivalence", alpha=0.05, beta=0.20,
 varlambda=c(1,1), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0.5,
 rho=c(0.05, 0.07), r=0.1)

# Ex 5. (Check back next version)
getSizeTTE(design="crossover", test="equality", alpha=0.05, beta=0.20,
 varlambda=c(1,1), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0.5,
 rho=c(0.05, 0.07), r=0.1)

# Ex 6. (Check back next version)
getSizeTTE(design="crossover", test="noninferiority", alpha=0.05,
 beta=0.20, varlambda=c(1,1), k=1, ttotal=3, taccrual=1, gamma=0.00001,
 delta=0.5, rho=c(0.05, 0.07), r=0.1)

# Ex 7. (Check back next version)
getSizeTTE(design="crossover", test="superiority", alpha=0.05, beta=0.20,
 varlambda=c(1,1), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0.5,
 rho=c(0.05, 0.07), r=0.1)

# Ex 8. (Check back next version)
getSizeTTE(design="crossover", test="equivalence", alpha=0.05, beta=0.20,
 varlambda=c(1,1), k=1, ttotal=3, taccrual=1, gamma=0.00001, delta=0.5,
 rho=c(0.05, 0.07), r=0.1)
}
