% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastHMMES.R
\name{ForecastHMMES}
\alias{ForecastHMMES}
\title{Expected shortfall (ES) of a univariate HMM at time n+k1, n+k2, ...}
\usage{
ForecastHMMES(U, family, theta, Q, eta, k = 1)
}
\arguments{
\item{U}{value (1  x 1) at which the expected shortfall needs to be computed; between 0 and 1; (e.g 0.01, 0.05)}

\item{family}{distribution name; run the function distributions() for help}

\item{theta}{parameters; (r  x p)}

\item{Q}{probability transition  matrix; (r  x r)}

\item{eta}{vector of the estimated probability of each regime at time n; (1  x r)}

\item{k}{prediction times (may be a vector of integers).}
}
\value{
\item{es}{expected shortfall (1 x horizon)}
}
\description{
This function computes the ES of a univariate HMM for multiple horizons, given observations up to time n
}
\examples{
family = "gaussian"

theta = matrix(c(-1.5, 1.7, 1, 1),2,2)
Q = matrix(c(0.8, 0.3, 0.2, 0.7), 2, 2)
eta = c(0.96091218, 0.03908782)

forecastedES = ForecastHMMES(U=c(0.01), family, theta=theta, Q=Q, eta=eta, k=c(1,2,3,4,5))
print('Forecasted expected shortfall : ')
print(forecastedES)

}
