% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searcher_efficiency_figure_functions.R
\name{plot.pkmSet}
\alias{plot.pkmSet}
\title{Plot results of a set of SE models}
\usage{
\method{plot}{pkmSet}(x, specificModel = NULL, cols = NULL, CL = NULL, ...)
}
\arguments{
\item{x}{pk model set of class pkmSet}

\item{specificModel}{the name(s) or index number(s) of specific model(s)
to restrict the plot}

\item{cols}{named vector of colors to use for the specific and reference
models}

\item{CL}{confidence level}

\item{...}{to be sent to subfunctions}
}
\value{
a set of plots
}
\description{
Produce a set of figures for a set of SE models, as fit by
  \code{\link{pkmSet}}
}
\examples{
  data(wind_RP)
  mod <- pkmSet(formula_p = p ~ Season, formula_k = k ~ Season,
           data = wind_RP$SE
         )
  plot(mod)

}
