% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortality_figure_functions.R
\name{plot.estM}
\alias{plot.estM}
\title{Plot total mortality estimation}
\usage{
\method{plot}{estM}(x, ..., CL = 0.9)
}
\arguments{
\item{x}{\code{estM} object}

\item{...}{arguments to pass down}

\item{CL}{confidence level}
}
\description{
\code{plot} defined for class \code{estM} objects
}
\examples{
 \dontrun{
 data(mock)
 model_SE <- pkm(formula_p = p ~ HabitatType, formula_k = k ~ 1,
              data = mock$SE)
 model_CP <- cpm(formula_l = l ~ Visibility, formula_s = s ~ Visibility, 
               data = mock$CP, dist = "weibull",
               left = "LastPresentDecimalDays", 
               right = "FirstAbsentDecimalDays")
 eM <- estM(nsim = 1000, data_CO = mock$CO, data_SS = mock$SS, 
         data_DWP = mock$DWP, frac = 1, model_SE = model_SE, 
         model_CP = model_CP, COdate = "DateFound",
         DWPCol = "S", sizeCol = NULL)
 plot(eM)
 }

}
