% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GauPro_S3.R
\name{predict.GauPro}
\alias{predict.GauPro}
\title{Predict for class GauPro}
\usage{
\method{predict}{GauPro}(object, XX, se.fit = F, covmat = F,
  split_speed = T, ...)
}
\arguments{
\item{object}{Object of class GauPro}

\item{XX}{new points to predict}

\item{se.fit}{Should standard error be returned (and variance)?}

\item{covmat}{Should the covariance matrix be returned?}

\item{split_speed}{Should the calculation be split up to speed it up?}

\item{...}{Additional parameters}
}
\value{
Prediction from object at XX
}
\description{
Predict for class GauPro
}
\examples{
n <- 12
x <- matrix(seq(0,1,length.out = n), ncol=1)
y <- sin(2*pi*x) + rnorm(n,0,1e-1)
gp <- GauPro(X=x, Z=y, parallel=FALSE)
predict(gp, .448)
}
