% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator.R
\name{indicator}
\alias{indicator}
\title{Conservation indicator across taxa based on gap analysis results}
\usage{
indicator(FCSc_mean_df)
}
\arguments{
\item{FCSc_mean_df}{A data frame object result of the function FCSc_mean}
}
\value{
This function returns a data frame object with the following columns:

\tabular{rr}{
 opt \tab Final conservation score option \cr
 count_HP \tab Count of taxa high priority for conservation action \cr
 count_MP \tab Count of taxa medium priority for conservation action \cr
 count_LP \tab Count of taxa low priority for conservation action \cr
 count_SC \tab Count of taxa sufficiently conserved \cr
 count_LP_SC \tab Count of taxa low priority for conservation action or sufficiently conserved \cr
 proportion_HP \tab Proportion of taxa high priority for conservation action \cr
 proportion_MP \tab Proportion of taxa medium priority for conservation action   \cr
 proportion_LP \tab Proportion of taxa low priority for conservation action \cr
 proportion_SC \tab  Proportion of taxa sufficiently conserved  \cr
 proportion_LP_SC \tab Proportion of taxa low priority for conservation action or sufficiently conserved (indicator) \cr
}
}
\description{
This function uses a data.frame resulting from the function FCSc_mean and
 computes a conservation indicator across taxa.
}
\examples{
##Obtaining occurrences from example
data(CucurbitaData)
##Obtaining species names from the data
Cucurbita_splist <- unique(CucurbitaData$species)
##Obtaining raster_list
data(CucurbitaRasters)
CucurbitaRasters <- raster::unstack(CucurbitaRasters)
##Obtaining protected areas raster
data(ProtectedAreas)
##Obtaining ecoregions shapefile
data(ecoregions)
#Running all three ex situ gap analysis steps using FCSex function
FCSex_df <- FCSex(Species_list=Cucurbita_splist,
                  Occurrence_data=CucurbitaData,
                  Raster_list=CucurbitaRasters,
                  Buffer_distance=50000,
                  Ecoregions_shp=ecoregions)
#Running all three in situ gap analysis steps using FCSin function
FCSin_df <- FCSin(Species_list=Cucurbita_splist,
                  Occurrence_data=CucurbitaData,
                  Raster_list=CucurbitaRasters,
                  Ecoregions_shp=ecoregions,
                  Pro_areas=ProtectedAreas)
## Combine gap analysis metrics
FCSc_mean_df <- FCSc_mean(FCSex_df = FCSex_df,FCSin_df = FCSin_df)
#Running indicator function
indicator_df  <- indicator(FCSc_mean_df)

}
\references{
Khoury et al. (2019) Ecological Indicators 98:420-429. doi: 10.1016/j.ecolind.2018.11.016
}
