#' Generalized Waring Regression Model for Count Data
#'
#' Statistical functions to fit, validate and describe a Generalized Waring Regression Model (GWRM).
#'
#' \pkg{GWRM} is a package for fitting and computing Generalized Waring Regression Models. It includes functions for fitting the model to data, for diagnosis and for computing important statistics, as those related to the partition of the variance. It also includes the dataset and the example of Rodriguez-Avi et al. (2009). The main function you're likely to need from \pkg{GWRM} is \code{gw}, in order to obtain a GWRM fit from data. 
#'
#' @docType package
#' 
#' @name GWRM
#' 
#' @references Rodriguez-Avi, J., Conde-Sanchez, A., Saez-Castillo, A. J., Olmo-Jimenez, M. J. and Martinez Rodriguez, A. M.(2009). A generalized Waring regression model for count data. \emph{Computational Statistics and Data Analysis}, \bold{53}, pp. 3717-3725.
NULL