% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWex_lib.r
\name{simGwexModel}
\alias{simGwexModel}
\title{simGwexModel}
\usage{
simGwexModel(objGwexFit, nb.rep = 10, d.start = as.Date("01011900",
  "\%d\%m\%Y"), d.end = as.Date("31121999", "\%d\%m\%Y"),
  objGwexObs = NULL, prob.class = c(0.5, 0.75, 0.9, 0.99),
  objGwexSim = NULL, nCluster = 1)
}
\arguments{
\item{objGwexFit}{an object of class \code{\linkS4class{GwexFit}}}

\item{nb.rep}{number of repetitions of scenarios}

\item{d.start}{a starting date for the simulation}

\item{d.end}{an ending date for the simulation}

\item{objGwexObs}{optional: an object of class \code{\linkS4class{GwexObs}} if we need the observations to simulate (disaggregation prec 3D -> 1D)}

\item{prob.class}{vector of probabilities indicating class of "similar" mean intensities}

\item{objGwexSim}{optional: an object of class \code{\linkS4class{GwexSim}} if we need simulations to simulate (temp conditional to prec)}

\item{nCluster}{optional, number of clusters which can be used for the parallel computation}
}
\value{
\item{GwexSim}{an object of class \code{\linkS4class{GwexSim}}. Contains sim (3D-array with the simulations) and a vector of dates}
}
\description{
Simulate from a GWex model
}
\examples{
# vector of dates
vecDates = seq(from=as.Date("01/01/2005",format="\%d/\%m/\%Y"),
to=as.Date("31/12/2014",format="\%d/\%m/\%Y"),by='day')

###############################################################
#               FIT AND SIMULATE FROM THE PRECIPITATION MODEL
###############################################################
# Format observations: create a G-Wex object
myObsPrec = GwexObs(variable='Prec',date=vecDates,obs=dailyPrecipGWEX[,1:2])

# default options except for 'nChainFit'
list.options = list(nChainFit=1000)

# generate 2 scenarios for one year, using a existing 'GwexFit' object
mySimPrec = simGwexModel(objGwexFit=myParPrecGWEX, nb.rep=2, d.start=vecDates[1],
d.end=vecDates[365])
mySimPrec # print object

###############################################################
#     FIT AND SIMULATE FROM THE TEMPERATURE MODEL, COND. TO PRECIPITATION
###############################################################
# Format observations: create a G-Wex object
myObsTemp = GwexObs(variable='Temp',date=vecDates,obs=dailyTemperGWEX)

# generate 2 scenarios for one year, using a existing 'GwexFit' object
mySimTemp = simGwexModel(objGwexFit=myParTempGWEX, nb.rep=2, d.start=vecDates[1], 
d.end=vecDates[365])
mySimTemp # print object
}
\author{
Guillaume Evin
}
