% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_GSOD.R
\name{get_GSOD}
\alias{get_GSOD}
\title{Download and Return a data.table Object of GSOD Weather Data}
\usage{
get_GSOD(
  years,
  station = NULL,
  country = NULL,
  max_missing = NULL,
  agroclimatology = FALSE
)
}
\arguments{
\item{years}{Year(s) of weather data to download.}

\item{station}{Optional.  Specify a station or multiple stations for which to
retrieve, check and clean weather data using \var{STATION}.  The
\acronym{NCEI} reports years for which the data are available.  This function
checks against these years.  However, not all cases are properly documented
and in some cases files may not exist for download even though it is
indicated that data was recorded for the station for a particular year.  If a
station is specified that does not have an existing file on the server, this
function will silently fail and move on to existing files for download and
cleaning.}

\item{country}{Optional.  Specify a country for which to retrieve weather
data; full name, 2 or 3 letter \acronym{ISO} or 2 letter \acronym{FIPS} codes
can be used.  All stations within the specified country will be returned.}

\item{max_missing}{Optional.  The maximum number of days allowed to be
missing from a station's data before it is excluded from final file output.}

\item{agroclimatology}{Optional.  Logical.  Only clean data for stations
between latitudes 60 and -60 for agroclimatology work, defaults to `FALSE`.
Set to `TRUE` to include only stations within the confines of these
latitudes.}
}
\value{
A data frame as a \code{\link[data.table]{data.table}} object of
\acronym{GSOD} weather data.
}
\description{
This function automates downloading, cleaning, reformatting of data from
the Global Surface Summary of the Day (\acronym{GSOD}) data provided by the
\href{https://www.ncei.noaa.gov/access/metadata/landing-page/bin/iso?id=gov.noaa.ncdc:C00516}{US National Centers for Environmental Information (NCEI)},
Three additional useful elements: saturation vapour pressure (es), actual
vapour pressure (ea) and relative humidity (RH) are calculated and returned
in the final data frame using the improved August-Roche-Magnus approximation
(Alduchov and Eskridge 1996).
}
\details{
All units are converted to International System of Units (SI), \emph{e.g.},
Fahrenheit to Celsius and inches to millimetres.

Data summarise each year by station, which include vapour pressure and
relative humidity elements calculated from existing data in \acronym{GSOD}.

All missing values in resulting files are represented as \code{NA}
regardless of which field they occur in.

For a complete list of the fields and description of the contents and units,
please refer to Appendix 1 in the \CRANpkg{GSODR} vignette,
\code{vignette("GSODR", package = "GSODR")}.

For more information see the description of the data provided by
\acronym{NCEI}, \url{https://www.ncei.noaa.gov/data/global-summary-of-the-day/doc/readme.txt}.
}
\note{
\CRANpkg{GSODR} attempts to validate year and station combination
requests, however, in certain cases the start and end date may encompass
years where no data is available.  In these cases no data will be returned.
It is suggested that the user check the latest data availability for the
station(s) desired using \link{get_inventory} as this list is frequently
updated by the \acronym{NCEI} and is not shipped with \CRANpkg{GSODR}.

While \CRANpkg{GSODR} does not distribute GSOD weather data, users of
the data should note the conditions that the U.S. \acronym{NCEI} places upon
the \acronym{GSOD} data.
\dQuote{The following data and products may have conditions placed on their
 international commercial use.  They can be used within the U.S. or for non-
 commercial international activities without restriction.  The non-U.S. data
 cannot be redistributed for commercial purposes.  Re-distribution of these
 data by others must provide this same notification.  A log of IP addresses
 accessing these data and products will be maintained and may be made
 available to data providers.}
}
\section{References}{


Alduchov, O.A. and Eskridge, R.E., 1996. Improved Magnus form approximation
of saturation vapor pressure. Journal of Applied Meteorology and Climatology,
35(4), pp.601-609. DOI:
<10.1175%2F1520-0450%281996%29035%3C0601%3AIMFAOS%3E2.0.CO%3B2>.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download weather station data for Toowoomba, Queensland for 2010
tbar <- get_GSOD(years = 2010, station = "955510-99999")

# Download weather data for the year 1929
w_1929 <- get_GSOD(years = 1929)

# Download weather data for the year 1929 for Ireland
ie_1929 <- get_GSOD(years = 1929, country = "Ireland")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{reformat_GSOD}}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
