% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSCAD_DL.R
\name{UpDic}
\alias{UpDic}
\alias{UpDicMask}
\title{Update dictionary in GSCAD}
\usage{
UpDic(Y, alpha, rho = 1, lambda = 0.01, c = 3.7, maxrun_ADMM = 100,
  err_bnd = 1e-04)

UpDicMask(Y, alpha, mask, rho = 1, lambda = 0.01, c = 3.7,
  maxrun_ADMM = 100, err_bnd = 1e-04)
}
\arguments{
\item{Y}{The image to be denoised. Inform of matrix.}

\item{alpha}{Sparse coding.}

\item{rho}{Parameter for the augmented Lagrangian function.}

\item{c, lambda}{parameters for GSCAD}

\item{maxrun_ADMM}{Maximun number of iterations run for ADMM}

\item{err_bnd}{Stopping criterion for iterations.}

\item{mask}{{0,1} matrix of the same size as Y
to indicate the location of corrupted pixels.}
}
\value{
The updated sparse dictionary .
}
\description{
When the sparce coding \code{A={alpha_1,...,alpha_n}} is given, update
 dictionary by solving problem (6) in \url{https://arxiv.org/abs/1605.07870}
 using ADMM. #'
}
\section{Functions}{
\itemize{
\item \code{UpDicMask}: Adding mask {0,1} matrix of the same size as Y to indicate
the location of corrupted pixel
}}

