% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotResult}
\alias{plotResult}
\title{Plot results of a run}
\usage{
plotResult(
  res,
  variable = c("pearson", "spearman", "rmse", "time_per_fold", "coeff_det", "mae"),
  x.label = c("both", "train_only", "test_only"),
  plot.type = c("box", "bar", "bar_conf95"),
  strata = c("no_strata", "avg_strata", "single")
)
}
\arguments{
\item{res}{a result data frame containing the output of GROAN.run}

\item{variable}{name of the variable to be used as y values}

\item{x.label}{select what to put on x-axis between both train and test dataset (default), train dataset only or test dataset only}

\item{plot.type}{a string indicating the type of plot to be obtained}

\item{strata}{string determining behaviour toward strata. If \code{'no_strata'} will plot
accuracies not considering strata. If \code{'avg_strata'} will average single
strata accuracies. If \code{'single'} each strata will be represented separately.}
}
\value{
a ggplot2 object
}
\description{
This function uses ggplot2 package (which must be installed) to
graphically render the result of a run. The function receive as
input the output of GROAN.run and returns a ggplot2 object (that
can be further customized).
Currently implemented types of plot are:
\itemize{
  \item \code{box} : boxplot, showing the distribution of repetitions. See \link[ggplot2]{geom_boxplot}
  \item \code{bar} : barplot, showing the average over repetitions. See \link[ggplot2]{stat_summary}
  \item \code{bar_conf95} : same as 'bar', but with 95\% confidence intervals
  }
}
