% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{input_maps}
\alias{input_maps}
\title{Map average load input by source}
\usage{
input_maps(
  catch_data,
  annual_data,
  sh_file,
  basin_name,
  plot.type,
  style_map = "fisher",
  scale_barTextS = 0.7,
  legend_position = 1
)
}
\arguments{
\item{catch_data}{data frame. Definition of the topological sequence of
catchments.}

\item{annual_data}{data frame. Sources of nutrient for each year and
catchments.}

\item{sh_file}{sf object. The spatial information.}

\item{basin_name}{character. The title of the map}

\item{plot.type}{character. Alternatives of the map: input load (kt) by type
divided by year and catchment. “gr1”: by km2; “gr2”: by year/km2.}

\item{style_map}{character. Alternatives to create the intervals in the maps.
Chosen style: one of "fixed", "sd", "equal", "pretty", "quantile", "kmeans",
"hclust", "bclust", "fisher", "jenks".}

\item{scale_barTextS}{numeric. To modify the size of the text in the legend.}

\item{legend_position}{numeric. Legend position: 1 (default): "right",
"bottom"; 2: "left", "up"; 3: "right", "bottom"; 4: "right", "up".}
}
\value{
No return value, called for the side effect of drawing a plot
}
\description{
Map showing the mean load input by source
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
data(sh_file)
# The title of the plot
mapTitle <- "Time series for the Lay Basin"
# the Input Load Map by source type 1 (lines)
input_maps(catch_data_TN, annual_data_TN, sh_file, mapTitle, "gr1",
legend_position = 2)
# the Input Load Map by source type 2 (lines & area)
input_maps(catch_data_TN, annual_data_TN, sh_file, mapTitle, "gr2",
legend_position = 2)
}

}
