% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbgp_snpData.R
\name{bbgp_snpData}
\alias{bbgp_snpData}
\title{Obtaining counts data in the format of example snpData by using
the sample data file.}
\usage{
bbgp_snpData(dataFileName, noHeaderLines = 1, noInfoColumns = 3,
  noOptions = 6, sep = ":")
}
\arguments{
\item{dataFileName}{Name of the raw data file}

\item{noHeaderLines}{Number of header lines, set to 1 by default.}

\item{noInfoColumns}{Number of columns which contain information about the SNP locations.
These columns are used to construct SNP IDs.}

\item{noOptions}{Number of possible alterations separated by the character defined in "sep"
Default is 6, assuming the form A:T:C:G:N:Del}

\item{sep}{Character which separates the alterations. Default is set to ":".}
}
\value{
List of snpData which contains counts in the "counts" matrix and sequencing
depth values in the "seq_depth" matrix. SNP IDs are stored as row names, and time
points are stored as column names.
}
\description{
Function for extracting the required data for the experimental evolution application.
}
\examples{
# dataFileName="sampleCountsData"
# snpData=bbgp_snpData(dataFileName)

}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\keyword{bbgp}
\keyword{snpData}

