% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SunsetSunrise.R
\name{SunRiseSet}
\alias{SunRiseSet}
\title{Calculate sunset and sunrise for a given date at given location and observer height}
\usage{
SunRiseSet(date = "2016-07-01", phi = 51.176, lambda = 4.326, H = 0)
}
\arguments{
\item{date}{POSIXct object or date specificied in unambiguous format. See \code{\link{as.POSIXct}}}

\item{phi}{Latitude}

\item{lambda}{Longitude}

\item{H}{Height of location where fDL is to be calculated}
}
\value{
Two element vector with sunrise and sunset time
}
\description{
Calculate sunset and sunrise for a given date at given location and observer height
}
\details{
This is an implementation of the algorithm found in the explanatory supplement of the astronomical almanac p484 and further.
}
\examples{
fDLfun("2016-06-21")
}
\seealso{
\code{\link{fDLfun}}
}
\author{
Tom Cox <tom.cox@uantwerp.be>
}
