% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_GPS.R
\name{train_gps}
\alias{train_gps}
\title{Train a model for generalized propensity score}
\usage{
train_gps(cov_mt, w_all, sl_lib, dnorm_log)
}
\arguments{
\item{cov_mt}{A covariate matrix containing all covariates. Each row is a
data sample and each column is a covariate.}

\item{w_all}{A vector of observed exposure levels.}

\item{sl_lib}{A vector of SuperLearner's package libraries.}

\item{dnorm_log}{Logical, if TRUE, probabilities p are given as log(p).}
}
\value{
A data.frame that includes:
\itemize{
\item a vector of estimated GPS at the observed exposure levels;
\item a vector of estimated conditional means of exposure levels when the covariates are fixed
at the observed values;
\item estimated standard deviation of exposure levels
}
}
\description{
Estimates the conditional mean and sd of exposure level as a function of
covariates.
}
\examples{
\donttest{
data <- generate_synthetic_data(sample_size = 200)
GPS_m <- train_gps(cov_mt = data[,-(1:2)],
                  w_all = data$treat,
                  sl_lib = c("SL.xgboost"),
                  dnorm_log = FALSE)
}
}
