% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_posterior_sd_nn.R
\name{compute_posterior_sd_nn}
\alias{compute_posterior_sd_nn}
\title{Calculate posterior standard deviations for nnGP model}
\usage{
compute_posterior_sd_nn(
  hyperparam,
  w,
  GPS_w,
  obs_ord,
  sigma2,
  kernel_fn = function(x) exp(-x^2),
  n_neighbor = 10,
  expand = 1,
  block_size = 10000
)
}
\arguments{
\item{hyperparam}{The values of hyperparameters in the GP model.}

\item{w}{The exposure level for the point of interest on the CERF.}

\item{GPS_w}{The GPS for all samples when their exposure levels are set
at \code{w}.}

\item{obs_ord}{A matrix of two columns. The first column is the observed
exposure levels of all samples; the second is the GPS at the observed
exposure levels. The rows are in ascending order for the first column.}

\item{sigma2}{A scaler representing \code{sigma^2}.}

\item{kernel_fn}{The covariance function of the GP.}

\item{n_neighbor}{Number of nearest neighbors on one side
(see also \code{expand}).}

\item{expand}{A scaling factor to determine the total number of nearest
neighbors. The total is \code{2*expand*n_neighbor}.}

\item{block_size}{Number of samples included in a computation block.
Mainly used to balance the speed and memory requirement.
Larger \code{block_size} is faster, but requires more memory.}
}
\value{
The posterior standard deviation of the estimated CERF at \code{w}.
}
\description{
Calculates the posterior standard deviation of a point on the CERF based on
the nnGP model.
}
\keyword{internal}
