% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaSPUtils.R
\name{gp.optim}
\alias{gp.optim}
\title{A wraper to fit a Gaussian stochastic process model with optimization methods}
\usage{
gp.optim(obj, method = "MMLE", opt = NULL, bound = NULL)
}
\arguments{
\item{obj}{an \code{S4} object \linkS4class{gp}}

\item{method}{a string indicating the parameter estimation method:
\describe{
\item{MPLE}{This indicates that the \emph{maximum profile likelihood estimation} 
(\strong{MPLE}) is used.}
\item{MMLE}{This indicates that the \emph{maximum marginal likelihood estimation} 
(\strong{MMLE}) is used.}
\item{MAP}{This indicates that the marginal/integrated posterior is maximized.}
}}

\item{opt}{a list of arguments to setup the \code{\link[stats]{optim}} routine. Current implementation uses three arguments: 
\describe{
 \item{method}{The optimization method: \code{Nelder-Mead} or \code{L-BFGS-B}.}
\item{lower}{The lower bound for parameters.}
\item{upper}{The upper bound for parameters.}
}}

\item{bound}{Default value is \code{NULL}. Otherwise, it should be a list
containing the following elements depending on the covariance class:
\describe{
\item{\strong{nugget}}{a list of bounds for the nugget parameter.
It is a list containing lower bound \strong{lb} and 
upper bound \strong{ub} with default value 
\code{list(lb=0, ub=Inf)}.}
\item{\strong{range}}{a list of bounds for the range parameter. Tt has default value
\code{range=list(lb=0, ub=Inf)} for the Confluent Hypergeometric covariance, the Matérn covariance, exponential covariance, Gaussian 
covariance, powered-exponential covariance, and Cauchy covariance. The log of range parameterization
 is used: \eqn{\log(\phi)}.}
\item{\strong{tail}}{a list of bounds for the tail decay parameter. It has default value
\code{list(lb=0, ub=Inf)}} for the Confluent Hypergeometric covariance and the Cauchy covariance.
 \item{\strong{nu}}{a list of bounds for the smoothness parameter. It has default value 
\code{list(lb=0, ub=Inf)} for the Confluent Hypergeometric covariance and the Matérn covariance.
when the powered-exponential or Cauchy class 
is used, it has default value \strong{nu}=\code{list(lb=0, ub=2)}. 
This can be achived by specifying the \strong{lower} bound in \code{opt}.}
}}
}
\value{
a list of updated \code{\link{gp}} object \strong{obj} and 
fitted information \strong{fit}
}
\description{
This function is a wraper to estimate parameters in the GaSP model with different
choices of estimation methods using numerical optimization methods.
}
\examples{
 
code = function(x){
y = (sin(pi*x/5) + 0.2*cos(4*pi*x/5))*(x<=9.6) + (x/10-1)*(x>9.6) 
return(y)
}
n=100
input = seq(0, 20, length=n)
XX = seq(0, 20, length=99)
Ztrue = code(input)
set.seed(1234)
output = Ztrue + rnorm(length(Ztrue), sd=0.1)
obj = gp(formula=~1, output, input, 
        param=list(range=4, nugget=0.1,nu=2.5),
        smooth.est=FALSE,
        cov.model=list(family="matern", form="isotropic"))
        
fit.optim = gp.optim(obj, method="MPLE")


}
\seealso{
\link{GPBayes-package}, \code{\link{GaSP}}, \linkS4class{gp}, \code{\link{gp.mcmc}}
}
\author{
Pulong Ma \email{mpulong@gmail.com}
}
