% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankingFun.R
\name{distRankingGO}
\alias{distRankingGO}
\title{Provides ranking of GO-terms according to distance}
\usage{
distRankingGO(goterm, domain = "BP", plot = TRUE)
}
\arguments{
\item{goterm}{A list of GO-terms to be ordered}

\item{domain}{The ontology of the GO-terms. The default is "BP"}

\item{plot}{If FALSE the visualisation of the ordering is not provided. The default is TRUE.}
}
\value{
The function returns the ordered GO-terms, the indices corresponding to these GO-terms,
the distance between the GO-terms hierarchy level and the maximal depth of paths in the GO-DAG passing through these GO-terms and a plot of
the visualisaiton by default.
}
\description{
distRankingGO returns the ranking of GO-terms based on the GO-terms hierarchy level and the maximal
depth of paths in the GO-DAG passing through these GO-terms.
}
\examples{
goterm <- c("GO:0000278","GO:0006414","GO:0022403","GO:0006415",
"GO:0045047","GO:0072599","GO:0006613","GO:0000184","GO:0070972",
"GO:0006413","GO:0000087","GO:0000280","GO:0000279","GO:0006612",
"GO:0000956","GO:0048285","GO:0019080","GO:0019083","GO:0043624",
"GO:0006402","GO:0032984","GO:0006401","GO:0072594","GO:0019058",
"GO:0051301","GO:0016071","GO:0006412","GO:0002682","GO:0022411",
"GO:0006614")

#The GO-terms in the list are ordered
distRankingGO(goterm = goterm, domain = "BP", plot = TRUE)

}
