% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.ts.ng.ria.r
\name{make.ts.ng.ria}
\alias{make.ts.ng.ria}
\title{Make two-sample normal-gamma rule in action plot}
\usage{
make.ts.ng.ria(
  mu.0.c = 0,
  alpha.0.c = 2.5,
  beta.0.c = 10,
  n.0.c = 10,
  mu.0.t = 0,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  n.0.t = 1e-04,
  xbar.c = 0.25,
  s.c = 1.5,
  n.c = 40,
  xbar.t = 2.5,
  s.t = 1.5,
  n.t = 40,
  Delta.lrv = 1.5,
  Delta.tv = 3,
  tau.ng = 0.65,
  tau.lrv = 0.8,
  tau.tv = 0.2,
  seed = 1234,
  n.MC = 1000,
  nlines = 25,
  nlines.ria = 20,
  tsize = 4,
  add.table = TRUE
)
}
\arguments{
\item{mu.0.c}{prior mean for control group}

\item{alpha.0.c}{prior alpha parameter for control group}

\item{beta.0.c}{prior beta parameter for control group}

\item{n.0.c}{prior effective sample size parameter for control group}

\item{mu.0.t}{prior mean for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{n.0.t}{prior effective sample size parameter for treatment group}

\item{xbar.c}{control mean}

\item{s.c}{control sd}

\item{n.c}{control sample size}

\item{xbar.t}{treatment mean}

\item{s.t}{treatment sd}

\item{n.t}{treatment sample size}

\item{Delta.lrv}{TPP Lower Reference Value aka Min TPP}

\item{Delta.tv}{TPP Target Value aka Base TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.tv}{threshold associated with Base TPP}

\item{seed}{random seed}

\item{n.MC}{n for MC sampling}

\item{nlines}{Control for text spacing}

\item{nlines.ria}{Control for text spacing}

\item{tsize}{Control for text size}

\item{add.table}{provides extended output summaries}
}
\value{
A ggplot object is returned
}
\description{
Make two-sample normal-gamma rule in action plot
}
\examples{
my.ts.ng.ria <- make.ts.ng.ria(add.table=TRUE)
plot(my.ts.ng.ria[[1]])
my.ts.ng.ria[[2]]
my.ts.ng.ria[[3]]
my.ts.ng.ria[[4]]
}
