% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_cosinor.R
\name{print.cglmmTest}
\alias{print.cglmmTest}
\title{Print results of test of cosinor model}
\usage{
\method{print}{cglmmTest}(x, ...)
}
\arguments{
\item{x}{A \code{test_cosinor} object.}

\item{...}{Arguments passed to \code{print}}
}
\value{
\code{print(x)} returns \code{x} invisibly.
}
\description{
Print results of test of cosinor model
}
\examples{
data_2_component <- simulate_cosinor(
  n = 10000,
  mesor = 5,
  amp = c(2, 5),
  acro = c(0, pi),
  beta.mesor = 4,
  beta.amp = c(3, 4),
  beta.acro = c(0, pi / 2),
  family = "gaussian",
  n_components = 2,
  period = c(10, 12),
  beta.group = TRUE
)
mod_2_component <- cglmm(
  Y ~ group + amp_acro(times,
    n_components = 2, group = "group",
    period = c(10, 12)
  ),
  data = data_2_component
)
test_cosinor_levels(
  mod_2_component,
  param = "amp",
  x_str = "group"
)
}
