% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_spatial.R
\name{GIFT_spatial}
\alias{GIFT_spatial}
\title{Spatial selection of GIFT checklists}
\usage{
GIFT_spatial(
  shp = NULL,
  coordinates = NULL,
  overlap = "centroid_inside",
  entity_ID = NULL,
  GIFT_version = "latest",
  api = "https://gift.uni-goettingen.de/api/extended/"
)
}
\arguments{
\item{shp}{Shapefile provided by the user. Its Coordinate Reference System
(CRS) must be set to WGS84 (EPSG code 4326).}

\item{coordinates}{Custom set of coordinates. The format is a two columns,
the first one being longitudes and the second being latitudes. If 4
coordinates are given, the function assumes that these are the four corners
of a bounding box.}

\item{overlap}{A character string defining the criteria to use in order to
retrieve checklists. Available options are \code{centroid_inside},
\code{extent_intersect}, \code{shape_intersect} and \code{shape_inside}. For example,
\code{extent_intersect} means that every polygon from GIFT for which the extent
intersects the provided shape/coordinates will be retrieved.}

\item{entity_ID}{List of entity_ID to retrieve.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}

\item{api}{character string defining from which API the data will be
retrieved.}
}
\value{
A data frame with 3 columns: \emph{entity_ID} the identification
number of a polygon, \emph{geo_entity_ref} its name, and \emph{coverage}
which indicates the percentage of overlap between the provided shape and
the different polygons of GIFT.
}
\description{
Retrieve checklists overlapping with a shape file or a set of coordinates.
}
\examples{
\donttest{
data("western_mediterranean")
ex <- GIFT_spatial(shp = western_mediterranean, overlap = "centroid_inside")

custom_point <- cbind(9.9, 51)
ex2 <- GIFT_spatial(coordinates = custom_point,
overlap = "extent_intersect")

custom_extent <- cbind(c(-13, -18), c(27.5, 29.3))
ex3 <- GIFT_spatial(coordinates = custom_extent,
overlap = "extent_intersect")

custom_polygon <- cbind(c(-18, -16.9, -13, -13, -18, -18),
c(29.3, 33, 29.3, 27.5, 27.5, 29.3))
ex4 <- GIFT_spatial(coordinates = custom_polygon,
overlap = "extent_intersect")

custom_linestring <- rbind(c(9.9, 51), c(2.35, 48.9))
custom_linestring <- sf::st_as_sf(as.data.frame(custom_linestring),
coords = c("V1", "V2"))
custom_linestring <- dplyr::summarise(custom_linestring,
geometry = sf::st_combine(geometry))
sf::st_crs(custom_linestring) <- sf::st_crs(western_mediterranean)
ex5 <- GIFT_spatial(shp = custom_linestring, overlap = "extent_intersect")

}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_checklists]{GIFT_checklists()}}
}
