% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly.R
\name{quarterly}
\alias{quarterly}
\title{Calculate Quarterly Timseries}
\usage{
quarterly(x)
}
\arguments{
\item{x}{Object of class \code{ghcn_daily}. See \code{\link[=daily]{daily()}} for details.}
}
\value{
A tibble with the quarterly timeseries at the stations.
}
\description{
\code{quarterly()} aggregates the daily timeseries into a quarterly one.
Aggregation is done differently for TMIN, TMAX, and PRCP.
}
\details{
Quarters are defined as:
\describe{
\item{first}{January to March}
\item{second}{April to June}
\item{third}{July to September}
\item{fourth}{October to December}
}
Aggregation is done as:
\describe{
\item{TMAX}{Maximum temperature recorded in the quarter}
\item{TMIN}{Minimum temperature recorded in the quarter}
\item{PRCP}{Total (cumulative) precipitation amount in the quarter}
}
}
\examples{
quarterly(CA003076680)
}
