% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_smooth}
\alias{ggally_smooth}
\alias{ggally_smooth_loess}
\alias{ggally_smooth_lm}
\title{Plots the Scatter Plot with Smoothing}
\usage{
ggally_smooth(
  data,
  mapping,
  ...,
  method = "lm",
  formula = y ~ x,
  se = TRUE,
  shrink = TRUE
)

ggally_smooth_loess(data, mapping, ...)

ggally_smooth_lm(data, mapping, ...)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{method, se}{parameters supplied to \code{\link[ggplot2]{geom_smooth}}}

\item{formula, ...}{other arguments to add to geom_smooth}

\item{shrink}{boolean to determine if y range is reduced to range of points or points and error ribbon}
}
\description{
Add a smoothed condition mean with a given scatter plot.
}
\details{
Y limits are reduced to match original Y range with the goal of keeping the Y axis the same across plots.
}
\examples{
 data(tips, package = "reshape")
 ggally_smooth(tips, mapping = ggplot2::aes(x = total_bill, y = tip))
 ggally_smooth(tips, mapping = ggplot2::aes_string(x = "total_bill", y = "tip"))
 ggally_smooth(tips, mapping = ggplot2::aes_string(x = "total_bill", y = "tip", color = "sex"))
}
\author{
Barret Schloerke \email{schloerke@gmail.com}
}
\keyword{hplot}
