% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{inference}
\alias{inference}
\title{Statistical Inference for Gaussian Graphical Models}
\usage{
inference(object, method = "fdr", alpha = 0.05, ...)
}
\arguments{
\item{object}{An object of class \code{ggmncv}}

\item{method}{Character string. A correction method for multiple comparison (defaults to \code{fdr}).
Can be abbreviated. See \link[stats]{p.adjust}.}

\item{alpha}{Numeric. Significance level (defaults to \code{0.05}).}

\item{...}{Currently ignored.}
}
\value{
\itemize{

\item \code{Theta} De-sparsified precision matrix

\item \code{adj} Adjacency matrix based on the p-values.

\item \code{uncorrected} Uncorrected p-values

\item \code{corrected} Corected p-values

\item \code{method} The approach used for multiple comparisons

\item \code{alpha} Significance level
}
}
\description{
Compute p-values for each relation based on the de-sparsified precision matrix
\insertCite{jankova2015confidence}{GGMncv}.
}
\note{
This assumes the Gaussian data.
}
\examples{
# data
Y <- GGMncv::ptsd

# fit model
fit <- GGMncv(cor(Y), n = nrow(Y))


# statistical inference
inference(fit)


}
\references{
\insertAllCited{}
}
