% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/casanova.R
\name{casanova}
\alias{casanova}
\title{CASANOVA: Cumulative Aalen survival analyis-of-variance}
\usage{
casanova(
  formula,
  event = "event",
  data = NULL,
  nperm = 1999,
  cross = TRUE,
  nested.levels.unique = FALSE,
  rg = list(c(0, 0))
)
}
\arguments{
\item{formula}{A model \code{formula} object. The left hand side contains the time variable and the right
hand side contains the factor variables of interest. An interaction term must be
specified.}

\item{event}{The name of censoring status indicator with values 0=censored and
1=uncensored.
The default choice is "event"}

\item{data}{A data.frame, list or environment containing the variables in formula
and the censoring status
indicator. Default option is \code{NULL}.}

\item{nperm}{The number of permutations used for calculating the permuted p-value.
The default option is 1999.}

\item{cross}{logical. Should the crossing weight w(x) = 1 - 2x be included?
The default is \code{TRUE}.}

\item{nested.levels.unique}{A logical specifying whether the levels of the nested
factor(s) are labeled uniquely or not.
 Default is FALSE, i.e., the levels of the nested factor are the same for each
 level of the main factor.}

\item{rg}{A list containing the exponents \code{c(r, g)} of the
weights
  \eqn{w(x) = x^r (1-x)^g}. Both exponents need to be natural numbers including 0.
 Default is \code{list( c(0, 0) )} corresponding to the log-rank weight.}
}
\value{
A \code{casanova} object containing the following components:
 \item{pvalues_stat}{The p-values obtained by \eqn{\chi^2}-approximation}
 \item{pvalues_per}{The p-values of the permutation approach}
 \item{statistics}{The value of the casanova along with degrees of freedom of the
 central chi-square distribution and p-value, as well as the p-value of the
  permutation procedure.}
 \item{rg}{A list containing the exponents of the direction considered in the
 statistical analysis}
 \item{cross}{logical. Was the crossing direction considered in the statistical
 analysis}
 \item{indep}{logical. Were the directions specified by the user linearly
 independent?}
 \item{nperm}{The number of permutations used for calculating the permuted p-value.}
}
\description{
The function \code{casanova} calculates the Wald-type statistic based on the
combination of differently weighted Nelson-Aalen-type integrals. Respective p-values
are obtained by a \eqn{\chi^2}-approximation and a permutation approach, respectively.
}
\details{
The \code{casanova} function calculates the Wald-type statistic of weighted
Nelson-Aalen type integrals
for general factorial survival designs. Crossed as well as hierachically nested designs are
implemented. Moreover, the approach allows the combination of
different weights into a
joint statistic. The user can choose between weights of the following form:
w(x) = 1 - 2x (\code{cross = TRUE}) and w(x) = x^r * (1-x)^g for natural numbers
r,g (including 0). The function automatically check whether the specified weights
fulfill the linear independence assumption and choose a subset of linearly independent
weights if the original weights violate the aforemention assumption.

  The \code{casanova} function returns the test statistic as well as two
  corresponding p-values: the first is based on a \eqn{\chi^2} approximation and
  the second one is based on a permutation procedure.
}
\examples{
\donttest{
library("survival")
data(veteran)
out <- casanova(formula ="time ~ trt*celltype",event = "status",
 data = veteran)

## Detailed informations:
summary(out)
}
}
\references{
Ditzhaus, M., Janssen, A. and Pauly, M. (2020). Permutation inference in factorial survival designs with the
          CASANOVA. ArXiv preprint (arXiv:2004.10818v2).
}
