% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hysteresis.R
\name{hysteresis}
\alias{hysteresis}
\title{A function to automatically generate hysteresis plots for all
structural parameter estimates.}
\usage{
hysteresis(GERGM_Object, networks_to_simulate = 1000, burnin = 500,
  range = 4, steps = 20, initial_density = 0.2,
  simulation_method = c("Gibbs", "Metropolis"), proposal_variance = 0.1,
  seed = 12345, thin = 1, output_directory = NULL, output_name = NULL,
  parallel = FALSE)
}
\arguments{
\item{GERGM_Object}{A GERGM object returned by the gergm() estimation
function.}

\item{networks_to_simulate}{Number of simulations per unique parameter value
used in the hysteresis plots. Default is 1000.}

\item{burnin}{Number of samples from the MCMC simulation procedure that
will be discarded before drawing the samples used for hysteresis plots.
Default is 500.}

\item{range}{The magnitude of the interval over which theta parameter
values will be varied for the hysteresis plots. The actual range will be
vary from a minimum of theta_value - range * theta_std_error to a maximum of
theta_value + range * theta_std_error so the actual parameter ranges will be
scaled to the magnitude of the parameter estimate standard errors. Defaults to 4.}

\item{steps}{The number of theta values to simulate above and below the
estimated theta value within the given range. The total number of simulations
is then = 2 * steps + 1. Defaults to 20.}

\item{initial_density}{The initial network density used in simulations, can
range from 0 to 1. Defaults to 0.2.}

\item{simulation_method}{Simulation method for MCMC estimation. Default is
"Gibbs" but can also be set to "Metropolis".}

\item{proposal_variance}{The variance specified for the Metropolis Hastings
simulation method. This parameter is inversely proportional to the average
acceptance rate of the M-H sampler and should be adjusted so that the average
acceptance rate is approximately 0.25. Default is 0.1.}

\item{seed}{Seed used for reproducibility. Default is 123.}

\item{thin}{The proportion of samples that are kept from each simulation. For
example, thin = 1/200 will keep every 200th network in the overall simulated
sample. Default is 1.}

\item{output_directory}{The directory where you would like output generated
by this function to be saved. If NULL, then the current working directory will
be used. Defaults to NULL.}

\item{output_name}{The common name stem you would like to assign to all
plots generated by this function. If NULL, then no output will be saved to pdf
and plots will only be plotted to the graphics device.}

\item{parallel}{Logical indicating whether hysteresis plots for each theta
parameter should be simulated in parallel. Can greatly reduce runtime, but
the computer must have at least as many cores as theta parameters.
Defaults to FALSE.}
}
\value{
A list object containing network densities for simulated networks.
}
\description{
Hysteresis plots were introduced by: Snijders, Tom AB, et al.
"New specifications for exponential random graph models." Sociological
methodology 36.1 (2006): 99-153. They can tell the user about sensitivity of the parameter estimates and whether they should worry about degeneracy.
}
\examples{
\dontrun{
set.seed(12345)
net <- matrix(rnorm(100,0,20),10,10)
colnames(net) <- rownames(net) <- letters[1:10]
formula <- net ~  mutual + ttriads

test <- gergm(formula,
              normalization_type = "division",
              network_is_directed = TRUE,
              use_MPLE_only = FALSE,
              estimation_method = "Metropolis",
              number_of_networks_to_simulate = 40000,
              thin = 1/10,
              proposal_variance = 0.5,
              downweight_statistics_together = TRUE,
              MCMC_burnin = 10000,
              seed = 456,
              convergence_tolerance = 0.01,
              MPLE_gain_factor = 0,
              force_x_theta_updates = 4)

hysteresis_results <- hysteresis(
    test,
    networks_to_simulate = 1000,
    burnin = 500,
    range = 2,
    steps = 20,
    simulation_method = "Metropolis",
    proposal_variance = 0.5)
}
}
