#' @export
#' @title Some Examples Illustrating Short-Term Investment
#' @aliases gemShortTermInvestment_2_3
#' @description Some examples illustrating short-term investment.
#' @param ... arguments to be passed to the function sdm2.
#' @examples
#' \donttest{
#' #### an example with an exogenous investment rate
#' investment.rate <- 0.2
#' dst.firm <- node_new("output",
#'   type = "CD",
#'   alpha = 2, beta = c(0.5, 0.5),
#'   "prod", "lab"
#' )
#'
#' dst.laborer <- node_new("laborer.util",
#'   type = "CD",
#'   alpha = 1, beta = c(0.5, 0.5),
#'   "prod", "lab"
#' )
#'
#' dst.investor <- node_new("investor.util",
#'   type = "Leontief",
#'   a = 1,
#'   "prod"
#' )
#'
#' dstl <- list(dst.firm, dst.laborer, dst.investor)
#'
#' ge <- sdm2(
#'   A = dstl,
#'   B = diag(c(1, 0), 2, 3),
#'   S0Exg = matrix(c(
#'     NA, NA, NA,
#'     NA, 100 * (1 - investment.rate), 100 * investment.rate
#'   ), 2, 3, TRUE),
#'   names.commodity = c("prod", "lab"),
#'   names.agent = c("firm", "laborer", "investor"),
#'   numeraire = "prod"
#' )
#'
#' addmargins(ge$D, 2)
#'
#' ## an example with an exogenous investment level
#' dst.investor$current.investment.rate <- 0.5
#' investment.level <- 20
#'
#' ge <- sdm2(
#'   A = list(dst.firm, dst.laborer, dst.investor),
#'   B = diag(c(1, 0), 2, 3),
#'   S0Exg = matrix(c(
#'     NA, NA, NA,
#'     NA, 100, 0
#'   ), 2, 3, TRUE),
#'   names.commodity = c("prod", "lab"),
#'   names.agent = c("firm", "laborer", "investor"),
#'   numeraire = "prod",
#'   policy = function(time, A, state) {
#'     A[[3]]$current.investment.rate <- A[[3]]$current.investment.rate *
#'       (investment.level / state$last.z[3])
#'     state$S[2, 2] <- 100 * (1 - A[[3]]$current.investment.rate)
#'     state$S[2, 3] <- 100 * A[[3]]$current.investment.rate
#'     state
#'   }
#' )
#'
#' addmargins(ge$D, 2)
#' }

gemShortTermInvestment_2_3 <- function(...) sdm2(...)
