% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policyMeanValue.R
\name{policyMeanValue}
\alias{policyMeanValue}
\title{Mean Value Policy Function}
\usage{
policyMeanValue(time, state, state.history)
}
\arguments{
\item{time}{the current time.}

\item{state}{the current state.}

\item{state.history}{the state history, which is a list consisting of the time series of p, S, q, and z.}
}
\value{
A list consisting of p, S and B which specify the prices, supplies and supply coefficient matrix after adjustment.
}
\description{
When the time index is an integer multiple of 200, this policy sets the current prices and supplies to the averages of the previous 199 periods.
This policy function is mainly used as an argument of the function sdm2 in order to accelerate convergence when calculating general equilibrium.
}
\seealso{
\code{\link{makePolicyMeanValue}} \code{\link{sdm2}}  \code{\link{gemDualLinearProgramming}}.
}
