% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemCanonicalDynamicMacroeconomic_4_3.R
\name{gemCanonicalDynamicMacroeconomic_4_3}
\alias{gemCanonicalDynamicMacroeconomic_4_3}
\title{A Canonical Dynamic Macroeconomic General Equilibrium Model (see Torres, 2016)}
\usage{
gemCanonicalDynamicMacroeconomic_4_3(
  discount.factor = 0.97,
  depreciation.rate = 0.06,
  beta.lab.firm = 0.65,
  beta.lab.consumer = 0.6,
  ...
)
}
\arguments{
\item{discount.factor}{the intertemporal discount factor.}

\item{depreciation.rate}{the physical depreciation rate of capital stock.}

\item{beta.lab.firm}{the share parameter for labor of the Cobb-Douglas production function of the production firm.}

\item{beta.lab.consumer}{the share parameter for labor of the Cobb-Douglas utility function of the consumer.}

\item{...}{arguments to be to be passed to the function sdm2.}
}
\value{
A general equilibrium (see \code{\link{sdm2}})
}
\description{
A canonical dynamic macroeconomic general equilibrium model (see Torres, 2016, Table 2.1 and 2.2).
}
\details{
A general equilibrium model with 4 commodities (i.e. product, labor, capital and equity shares)
and 3 agents (i.e. a production firm, a consumer and a capital-leasing firm).
}
\examples{
\donttest{
ge <- gemCanonicalDynamicMacroeconomic_4_3(
  numberOfPeriods = 5000,
  priceAdjustmentVelocity = 0.03
)

## business cycle
de <- gemCanonicalDynamicMacroeconomic_4_3(
  numberOfPeriods = 1000,
  priceAdjustmentVelocity = 0.15
)

## A tax rate policy is implemented from the 600th period to stabilize the economy.
ge <- gemCanonicalDynamicMacroeconomic_4_3(
  numberOfPeriods = 1500,
  priceAdjustmentVelocity = 0.15,
  policy = Example9.10.policy.tax
)

matplot(ge$ts.z, type = "l")
plot(ge$policy.data, type = "l") # tax rates
}
}
\references{
Torres, Jose L. (2016, ISBN: 9781622730452) Introduction to Dynamic Macroeconomic General Equilibrium Models (Second Edition). Vernon Press.
}
