% Generated by roxygen2 (4.0.1): do not edit by hand
\name{JackHartley}
\alias{JackHartley}
\title{Confidence intervals for Hartley estimator based on jackknife method}
\usage{
JackHartley(ysA, ysB, pi_A, pi_B, domains_A, domains_B, conf_level, sdA = "srs",
sdB = "srs", strA = NULL, strB = NULL, clusA = NULL, clusB = NULL, NhA = NULL,
NhB = NULL, NclushA = NULL, NclushB = NULL, fcpA = FALSE, fcpB = FALSE)
}
\arguments{
\item{ysA}{A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{c} containing information about variable of interest from \eqn{s_A}.}

\item{ysB}{A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{c} containing information about variable of interest from \eqn{s_B}.}

\item{pi_A}{A numeric vector of length \eqn{n_A} or a square numeric matrix of dimension \eqn{n_A} containing first order or first and second order inclusion probabilities for units included in \eqn{s_A}.}

\item{pi_B}{A numeric vector of length \eqn{n_B} or a square numeric matrix of dimension \eqn{n_B} containing first order or first and second order inclusion probabilities for units included in \eqn{s_B}.}

\item{domains_A}{A character vector of size \eqn{n_A} indicating the domain each unit from \eqn{s_A} belongs to. Possible values are "a" and "ab".}

\item{domains_B}{A character vector of size \eqn{n_B} indicating the domain each unit from \eqn{s_B} belongs to. Possible values are "b" and "ba".}

\item{conf_level}{A numeric value indicating the confidence level for the confidence intervals.}

\item{sdA}{(Optional) A character vector indicating the sampling design considered in frame A. Possible values are "srs" (simple random sampling without replacement), "pps" (probabilities proportional to size sampling), "str" (stratified sampling), "clu" (cluster sampling) and "strclu" (stratified cluster sampling). Default is "srs".}

\item{sdB}{(Optional) A character vector indicating the sampling design considered in frame B. Possible values are "srs" (simple random sampling without replacement), "pps" (probabilities proportional to size sampling), "str" (stratified sampling), "clu" (cluster sampling) and "strclu" (stratified cluster sampling). Default is "srs".}

\item{strA}{(Optional) A numeric vector indicating the stratum each unit in frame A belongs to, if a stratified sampling or a stratified cluster sampling has been considered in frame A.}

\item{strB}{(Optional) A numeric vector indicating the stratum each unit in frame B belongs to, if a stratified sampling or a stratified cluster sampling has been considered in frame B.}

\item{clusA}{(Optional) A numeric vector indicating the cluster each unit in frame A belongs to, if a cluster sampling or a stratified cluster sampling has been considered in frame A.}

\item{clusB}{(Optional) A numeric vector indicating the cluster each unit in frame B belongs to, if a cluster sampling or a stratified cluster sampling has been considered in frame B.}

\item{NhA}{(Optional) A numeric vector indicating the population size in each stratum of frame A. This is only needed when \code{sdA = "str"} and \code{fcpA = TRUE}.}

\item{NhB}{(Optional) A numeric vector indicating the population size in each stratum of frame B. This is only needed when \code{sdB = "str"} and \code{fcpB = TRUE}.}

\item{NclushA}{(Optional) A numeric vector indicating the population number of clusters in each stratum of frame A. This is only needed when \code{sdA = "strclu"} and \code{fcpA = TRUE}.}

\item{NclushB}{(Optional) A numeric vector indicating the population number of clusters in each stratum of frame B. This is only needed when \code{sdB = "strclu"} and \code{fcpB = TRUE}.}

\item{fcpA}{(Optional) A logic value indicating if a finite population correction factor should be considered in frame A. Default is FALSE.}

\item{fcpB}{(Optional) A logic value indicating if a finite population correction factor should be considered in frame B. Default is FALSE.}
}
\value{
A numeric matrix containing estimations of population total and population mean and their corresponding confidence intervals obtained through jackknife method.
}
\description{
Calculates confidence intervals for Hartley estimator using jackknife procedure
}
\details{
Let suppose a non stratified sampling design in frame A and a stratified sampling design in frame B where frame has been divided into L strata and a sample of size \eqn{n_{Bl}} from the \eqn{N_{Bl}} composing the l-th stratum is selected
In this context, jackknife variance estimator of a estimator \eqn{\hat{Y}_c} is given by
 \deqn{v_J(\hat{Y}_c) = \frac{n_{A}-1}{n_{A}}\sum_{i\in s_A} (\hat{Y}_{c}^{A}(i) -\overline{Y}_{c}^{A})^2 + \sum_{l=1}^{L}\frac{n_{Bl}-1}{n_{Bl}}  \sum_{i\in s_{Bl}} (\hat{Y}_{c}^{B}(lj) -\overline{Y}_{c}^{Bl})^2}
with \eqn{\hat{Y}_c^A(i)} the value of estimator \eqn{\hat{Y}_c} after dropping \eqn{i-th} unit from \code{ysA} and \eqn{\overline{Y}_{c}^{A}} the mean of values \eqn{\hat{Y}_c^A(i)}.
Similarly, \eqn{\hat{Y}_c^B(lj)} is the value taken by \eqn{\hat{Y}_c} after dropping j-th unit of l-th from sample \code{ysB} and \eqn{\overline{Y}_{c}^{Bl}} is the mean of values \eqn{\hat{Y}_c^B(lj)}.
If needed, a finite population correction factor can be included in frames by replacing \eqn{\hat{Y}_{c}^{A}(i)} or \eqn{\hat{Y}_{c}^{B}(lj)} with \eqn{\hat{Y}_{c}^{A*}(i)= \hat{Y}_{c}+\sqrt{1-\overline{\pi}_A} (\hat{Y}_{c}^{A}(i) -\hat{Y}_{c})} or
\eqn{\hat{Y}_{c}^{B*}(lj)= \hat{Y}_{c}+\sqrt{1-\overline{\pi}_B} (\hat{Y}_{c}^{B}(lj) -\hat{Y}_{c})}, where \eqn{\overline{\pi}_A = \sum_{i \in s_A}\pi_{iA}/n_A} and \eqn{\overline{\pi}_B = \sum_{j \in s_B}\pi_{jB}/n_B}
A confidence interval for any parameter of interest, \eqn{Y} can be calculated, then, using the pivotal method.
}
\examples{
data(DatA)
data(DatB)

#Let obtain a 95\% jackknife confidence interval for variable Feeding,
#supposing a stratified sampling in frame A and a simple random sampling
#without replacement in frame B with no finite population correction
#factor in any frame.
JackHartley(DatA$Feed, DatB$Feed, DatA$ProbA, DatB$ProbB, DatA$Domain,
DatB$Domain, 0.95, "str", "srs", strA = DatA$Stratum)

#Let check how interval estimation varies when a finite
#population correction factor is considered in both frames.
JackHartley(DatA$Feed, DatB$Feed, DatA$ProbA, DatB$ProbB, DatA$Domain,
DatB$Domain, 0.95, "str", "srs", strA = DatA$Stratum,
NhA = c(727, 375, 113, 186, 115, 219), fcpA = TRUE, fcpB = TRUE)
}
\references{
Wolter, K. M. (2007)
 \emph{Introduction to Variance Estimation.}
 2nd Edition. Springer, Inc., New York.
}
\seealso{
\code{\link{Hartley}}
}

