% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.tip.sampling.R
\name{sim.extant.samples}
\alias{sim.extant.samples}
\title{Include extant samples in the fossil object, with optional rho sampling.}
\usage{
sim.extant.samples(fossils, tree = NULL, taxonomy = NULL, rho = 1, tol = NULL)
}
\arguments{
\item{fossils}{Fossils object.}

\item{tree}{Phylo object.}

\item{taxonomy}{Taxonomy object.}

\item{rho}{Extant species sampling probability.}

\item{tol}{Rounding error tolerance for tip ages.}
}
\value{
An object of class fossils containing extant tip samples equal to the age of the tips (i.e. 0.0).
}
\description{
Include extant samples in the fossil object, with optional rho sampling.
}
\examples{
# simulate tree
lambda = 0.1
mu = 0.05
tips = 8
t = TreeSim::sim.bd.taxa(tips, 1, lambda, mu)[[1]]

# simulate fossils
f = sim.fossils.poisson(0.5, t)

# simulate extant samples
f = sim.extant.samples(f, t, rho = 0.5)
plot(f, t)

}
