% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegmentCrowns.R
\name{SegmentCrowns}
\alias{SegmentCrowns}
\title{SegmentCrowns}
\usage{
SegmentCrowns(treetops, CHM, minHeight = 0, format = "raster",
  verbose = TRUE)
}
\arguments{
\item{treetops}{\link[sp]{SpatialPointsDataFrame}. The point locations of treetops. The function will generally produce a
number of crown segments equal to the number of treetops.}

\item{CHM}{Canopy height model in \link[raster]{raster} format.}

\item{minHeight}{numeric. The minimum height value for a \code{CHM} pixel to be considered as part of a crown segment.
All \code{CHM} pixels beneath this value will be masked out. Note that this value should be lower than the minimum
height of \code{treetops}.}

\item{format}{string. Format of the function's ouput. Can be set to either 'raster' or 'polygons'.}

\item{verbose}{logical. Print processing progress to console.}
}
\value{
Depending on the argument set with \code{format}, this function will return a map of outlined
crowns as either a RasterLayer (see \link[raster]{raster}), in which distinct crowns
are given a unique cell value, or a \link[sp]{SpatialPolygonsDataFrame}, in which each crown
is represented by a polygon.
}
\description{
Implements the \link[imager]{watershed} function to segment (i.e.: outline) crowns from a canopy height model.
Segmentation is guided by the point locations of treetops, typically detected using the \link{TreeTopFinder} function.
See Meyer & Beucher (1990) for details on watershed segmentation.
}
\details{
This function can return a crown map as either a \link[raster]{raster} or a \link[sp]{SpatialPolygonsDataFrame},
which are defined using the \code{format} argument. For most analytical purposes, it is preferable to have
crown outlines as polygons. However, polygonal crown maps take up significantly more disk space, and take
much longer to process. It is advisable to run this function using a raster output first, in order to check
its results and adjust parameters.

Although it is slower, using the 'polygons' output \code{format} provides the added benefit of transferring
treetop attributes (such as \emph{height}) to the newly created polygons. The area of each crown will also
automatically be calculated and added to the polygons' data under the \emph{crownArea} field. Furthermore,
"orphaned" segments (i.e.: outlines without an associated treetop) will be removed when
\code{format} is set to 'polygons'.
}
\examples{
# Use TreeTopFinder to detect treetops in demo canopy height model
ttops <- TreeTopFinder(CHMdemo, winFun = function(x){x * 0.06 + 0.5}, minHeight = 2)

# Set minimum tree crown height (should be LOWER than minimum treetop height)
minCrwnHgt <- 1

# Use SegmentCrowns to outline tree crowns
segs <- SegmentCrowns(ttops, CHMdemo, minCrwnHgt)
}
\references{
Meyer, F., & Beucher, S. (1990). Morphological segmentation. \emph{Journal of visual communication and
image representation, 1}(1), 21-46.
}
\seealso{
\code{\link{TreeTopFinder}} \code{\link{SpatialStatistics}} \code{\link[imager]{watershed}}
}

