% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v_gri.R
\name{v_gri}
\alias{v_gri}
\title{Calculate Tree Volumes With the GRI Volume Equations
\insertCite{franz_gri_methods_1973}{ForestElementsR}}
\usage{
v_gri(species_id, dbh_cm, height_m)
}
\arguments{
\item{species_id}{Vector of species id's following the \emph{tum_wwk_short}
species coding. Ideally, these species_id's are provided as an
\code{\link{fe_species_tum_wwk_short}} or an
\code{\link{fe_species_bavrn_state_short}} object. If they are provided as
another \code{fe_species} object, \code{v_gri} will make an attempt to
convert them into \code{\link{fe_species_tum_wwk_short}}. The exception is
the coding \code{\link{fe_species_bavrn_state}} which will be converted
into \code{\link{fe_species_bavrn_state_short}}. If all conversion attempts
fail, the function will terminate with an error. The species id's can also
be provided as numeric values (\code{double} or \code{integer}) or
\code{character}. These will be internally converted to
\code{\link{fe_species_tum_wwk_short}}. If this fails (i.e. the user
provided species codes are not defined in the \emph{tum_wwk_short} coding), an
error is thrown and the function terminates.}

\item{dbh_cm}{Vector of tree dbh values in cm (dbh = stem diameter at breast
height, i.e. 1.3 m)}

\item{height_m}{Vector of tree height values in m}
}
\value{
A vector of merchantable standing tree wood volumes over bark in m³.
"Merchantable" means only wood with a minimum diameter of 7 cm over bark is
taken into account. Therefore, for small trees without any merchandable
wood, the function will return 0 m³.
}
\description{
Merchantable standing tree volumes over bark calculated with the GRI volume
equations developed by Friedrich Franz in 1971. These volume equations are
standard in the German Federal State of Bavaria
}
\details{
The abbreviation \emph{GRI} stands for the German word "Großrauminventur" (large
area inventory). This forest inventory was conducted in 1971 by Friedrich
Franz and his team of the Chair for Forest Growth and Yield Science at the
Munich Ludwig-Maximilians-University
\insertCite{franz_gri_methods_1973}{ForestElementsR}. The inventory covered
the whole federal state of Bavaria (~ 70,600 km²). The volume equations
implemented in this function were calibrated with the data of several ten
thousands of trees which were felled for that purpose during the
inventory. The volume equations are available for exactly the species
(groups) defined in the coding \emph{tum_wwk_short}. If they are called with
another species coding supported by the package \strong{ForestElementsR},
\code{v_gri} will attempt to convert them accordingly.
}
\examples{
# Find out the species codes that work with v_gri
fe_species_get_coding_table("tum_wwk_short") |>
  dplyr::select(-genus, -species_no) |>
  dplyr::distinct()

# Merchantable volume of a European beech with dbh = 30 cm,
# and height = 29 m
v_gri("5", 30, 29)
v_gri(5, 30, 29)
v_gri(as_fe_species_tum_wwk_short(5), 30, 29)

# Several trees (three species, three sizes)
species_id <- fe_species_tum_wwk_short(c(1, 1, 1, 3, 3, 3, 5, 5, 5))
dbh_cm <- c(12, 30, 55, 12, 30, 55, 12, 30, 55)
height_m <- c(14, 33, 39, 14, 33, 39, 14, 33, 39)
v_gri(species_id, dbh_cm, height_m)

# The same, but the species id's are now originally defined in the
# coding of the 2012 German national forest inventory
species_id <- fe_species_ger_nfi_2012(
  c(10, 10, 10, 20, 20, 20, 100, 100, 100)
)
v_gri(species_id, dbh_cm, height_m)

}
\references{
\insertAllCited{}
}
