% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Monte_Carlo.R
\name{monte_carlo}
\alias{monte_carlo}
\title{Function to use Monte Carlo strategy}
\usage{
monte_carlo(object, size, iteration, fval = 0, figs = 0)
}
\arguments{
\item{object}{as output of 'prediction_errors()' function}

\item{size}{as volume of time series used in Monte Carlo strategy}

\item{iteration}{as number of iterations models to be applied}

\item{fval}{as a flag to view forecasted values in each iteration (default: 0, don't view values)}

\item{figs}{as a flag to view plots for each iteration (default: 0, don't view plots)}
}
\value{
Error values with provided models in each iteration along with the mean values
}
\description{
Function to use Monte Carlo strategy
}
\examples{
\dontrun{
library(forecast)
test3 <- function(data, nval){return(as.numeric(forecast(ets(data), h = nval)$mean))}
a <- prediction_errors(data = nottem,
    Method = c("test3(data, nval)"),
    MethodName = c("ETS"), append_ = 1)
monte_carlo(object = a1, size = 144, iteration = 10)
}
}
