% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/middleout.R
\name{csmo}
\alias{csmo}
\title{Cross-sectional middle-out reconciliation}
\usage{
csmo(base, agg_mat, id_rows = 1, weights, normalize = TRUE)
}
\arguments{
\item{base}{A (\eqn{h \times n_l}) numeric matrix containing the \eqn{l}-level
base forecast; \eqn{n_l} is the number of variables at level \eqn{l}, and
\eqn{h} is the forecast horizon.}

\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{id_rows}{A numeric vector indicating the \eqn{l}-level rows of \code{agg_mat}.}

\item{weights}{A (\eqn{h \times n_b}) numeric matrix containing the proportions for the
bottom time series; \eqn{h} is the forecast horizon, and \eqn{n_b} is the total number
of bottom variables.}

\item{normalize}{If \code{TRUE} (\emph{default}), the \code{weights} will sum to 1.}
}
\value{
A (\eqn{h \times n}) numeric matrix of cross-sectional reconciled forecasts.
}
\description{
The middle-out forecast reconciliation (Athanasopoulos et al., 2009) combines
top-down (\link{cstd}) and bottom-up (\link{csbu}) for genuine hierarchical/grouped
time series. Given the base forecasts of variables at an intermediate
level \eqn{l}, it performs
\itemize{
\item a top-down approach for the levels \eqn{<l};
\item a bottom-up approach for the levels \eqn{>l}.
}
}
\examples{
set.seed(123)
# Aggregation matrix for Z = X + Y, X = XX + XY and Y = YX + YY
A <- matrix(c(1,1,1,1,1,1,0,0,0,0,1,1), 3, byrow = TRUE)
# (3 x 2) top base forecasts vector (simulated), forecast horizon = 3
baseL2 <- matrix(rnorm(2*3, 5), 3, 2)
# Same weights for different forecast horizons
fix_weights <- runif(4)
reco <- csmo(base = baseL2, agg_mat = A, id_rows = 2:3, weights = fix_weights)

# Different weights for different forecast horizons
h_weights <- matrix(runif(4*3), 3, 4)
recoh <- csmo(base = baseL2, agg_mat = A, id_rows = 2:3, weights = h_weights)

}
\references{
Athanasopoulos, G., Ahmed, R. A. and Hyndman, R.J. (2009) Hierarchical forecasts
for Australian domestic tourism. \emph{International Journal of Forecasting} 25(1),
146–166. \doi{10.1016/j.ijforecast.2008.07.004}
}
\seealso{
Middle-out reconciliation: 
\code{\link{ctmo}()},
\code{\link{temo}()}

Cross-sectional framework: 
\code{\link{csboot}()},
\code{\link{csbu}()},
\code{\link{cscov}()},
\code{\link{cslcc}()},
\code{\link{csrec}()},
\code{\link{cstd}()},
\code{\link{cstools}()}
}
\concept{Framework: cross-sectional}
\concept{Reco: middle-out}
