% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srref.R
\name{srref}
\alias{srref}
\title{(Sparse) Reduced Row Echelon Form of a matrix}
\usage{
srref(A, tol = sqrt(.Machine$double.eps), verbose = FALSE, sparse = TRUE)
}
\arguments{
\item{A}{A numeric (possibly sparse) matrix.}

\item{tol}{Tolerance for checking for 0 pivot.}

\item{verbose}{If \code{TRUE}, print intermediate steps.}

\item{sparse}{Option to return sparse matrices (\emph{default} is \code{TRUE}).}
}
\value{
A (sparse) matrix with the same dimension as \mjseqn{\mathbf{A}}
}
\description{
Returns the reduced row echelon form of a (possibly sparse) matrix through Gauss-Jordan
elimination. This function is used by the \code{\link{ut2c}} function
to obtain a 'structural representation' of a general linearly constrained
multiple time series, from its zero-constraints kernel representation
(Di Fonzo and Girolimetto, 2020).
}
\references{
Di Fonzo, T., Girolimetto, D. (2020), Cross-Temporal Forecast Reconciliation:
Optimal Combination Method and Heuristic Alternatives, Department of Statistical
Sciences, University of Padua, \href{https://arxiv.org/abs/2006.08570}{arXiv:2006.08570}.
}
\seealso{
Other utilities: 
\code{\link{Cmatrix}()},
\code{\link{FoReco2ts}()},
\code{\link{commat}()},
\code{\link{ctf_tools}()},
\code{\link{hts_tools}()},
\code{\link{oct_bounds}()},
\code{\link{score_index}()},
\code{\link{shrink_estim}()},
\code{\link{thf_tools}()},
\code{\link{ut2c}()}
}
\author{
Originally written by John Fox and modified by Geoffrey Brent to fix a bug,
extended to deal with sparse matrices.
}
\concept{utilities}
