% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_observation_probability.R
\name{get_observation_probability}
\alias{get_observation_probability}
\title{Computes the probability of observations given the birds count from 
trajectories.}
\usage{
get_observation_probability(obs, hidden_count, use_log = TRUE)
}
\arguments{
\item{obs}{Matrix of I+2 rows and T+1 columns with observed 
bird counts. I is the numbers of sites, to which one adds the virtual 
sites 'death' and 'flight' and T is the horizon of the migration 
structure.}

\item{hidden_count}{Matrix of I+2 rows and T+1 columns with 
simulated bird counts. As computed by function get_count}

\item{use_log}{Boolean that states if the log probability should 
be returned.}
}
\value{
the probability (or log-probability) of the observed data given 
  simulated counts.
}
\description{
Computes the probability of observations given the birds count from 
              trajectories : P(O | Pi_[0:T])
}
\examples{
migr <- generate_toy_migration()
traj <- generate_trajectories( migr )
get_observation_probability( migr$observation, get_counts( migr, traj ), use_log = FALSE)
}
