% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qn.R
\name{Qn}
\alias{Qn}
\title{Calculate flow quantiles}
\usage{
Qn(TS, n = 0.1, by = "hyear")
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}

\item{n}{Numeric value of the quantile.  Default is 0.1.}

\item{by}{Character string indicating time unit to summarize by.  Default is
"hyear" for hydrologic year, see \code{\link{create.ts}}.  Other options 
are "year" for calendar year, "month", or "doy" for day of year.}
}
\value{
Returns a numeric vector of the calculated flow quantile for the time
  periods indicated with the "by" argument.  The "times" attribute contains the
  hydrologic year, calendar year, month, or day of year for each data point.
}
\description{
This function calculates flow quantiles by hydrologic year, calendar
year, month, or doy.
}
\examples{
data(cania.sub.ts)

# 50\% quantile, i.e. mean, by calendar year
res <- Qn(cania.sub.ts, n=0.5, by="year")
res2 <- screen.metric(res, "Q (m3/s)")

# Default 10\% quantile, by hydrologic year
res <- Qn(cania.sub.ts)
res2 <- screen.metric(res, "Q (m3/s)")
}
\author{
Jennifer Dierauer
}
