% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDB_prepare.R
\name{PDB_prepare}
\alias{PDB_prepare}
\title{PDB_prepare}
\usage{
PDB_prepare(file_name)
}
\arguments{
\item{file_name}{PDB file name to load that was split into chains, e.g. '6KZ5_A.pdb'}
}
\value{
returns a processed data frame with Fi-score 'Fi_score', normalised B factor values 'B_normalised' and secondary structure designations
}
\description{
Function to prepare a PDB file after it was pre-processed to generate Fi-score and normalised B factor values as well as secondary structure designations
}
\examples{
path_to_processed_PDB<- system.file("extdata", "3nf5_A.pdb", package="Fiscore")
# you can call PDB_prepare with the set path
head(PDB_prepare(path_to_processed_PDB))
}
