#' @title phi_psi_3D
#'
#' @description Function plots a 3D scatter plot with  a secondary structure element visualisation based on PDB file data; NOTE: NA refers to unidentified region, e.g., a disordered region. The plot includes information, such as phi and psi dihedral angles as well as normalised B-factor values.
#'
#' @param pdb_df Requires a PDB data frame generated by PDB_prepare
#' @return Interactive plot
#' @ImportFrom plotly  ayout
#' @ImportFrom plotly  plot_ly
#' @export
#' @examples
#' path_to_processed_PDB<- system.file("extdata", "pdb_df.tabular", package="Fiscore")
#' # basic usage of phi_psi_3D
#' pdb_df<-read.table(path_to_processed_PDB)
#' phi_psi_3D(pdb_df)
phi_psi_3D<-function(pdb_df){



  #plot structures


  plot<-plotly::plot_ly(data=pdb_df,x=pdb_df$"phi", y=pdb_df$"psi", z=pdb_df$"B_normalised", type="scatter3d", mode="markers", size=0.7,color=pdb_df$"Type")

  plotly::layout(plot,scene = list(xaxis = list(title = "phi"), yaxis = list(title = "psi"), zaxis = list(title ="B-factor normalised")))





}
