###
### 
### Ruey S. Tsay (2005)
### Analysis of Financial Time Series, 2nd ed.
### (Wiley)
###
### 

# p. 97
###
### ch. 3.  Conditional Heteroscedastic Models 
###
library(FinTS)

# p. 98 
##
## sec. 3.1.  Characteristics of volatility 
##

# p. 99
##
## sec. 3.2.  Structure of a model 
##

# Figure 3.1
data(m.intc7303)
ml.intc <- log(1+m.intc7303)

op <- par(mfcol=c(2,2))
Acf(as.numeric(ml.intc), main="(a) Log returns")
Acf(as.numeric(ml.intc)^2, main="(b) Squared log returns")
Acf(abs(as.numeric(ml.intc)), main="(c) Absolute log returns") 
pacf(as.numeric(ml.intc)^2, main="(b) Squared log returns")
par(op)
# adjust ylim = c(-.2, .4)
op <- par(mfcol=c(2,2))
Acf(as.numeric(ml.intc), main="(a) Log returns", ylim = c(-.2, .4))
Acf(as.numeric(ml.intc)^2, main="(b) Squared log returns", ylim = c(-.2, .4))
Acf(abs(as.numeric(ml.intc)), main="(c) Absolute log returns", ylim = c(-.2, .4)) 
pacf(as.numeric(ml.intc)^2, main="(b) Squared log returns", ylim = c(-.2, .4))
par(op) 


# p. 101 
##
## sec. 3.3.  Model Building 
##

# sec. 3.3.1.  Testing for ARCH effect 

# p. 102
data(m.intc7303)
str(m.intc7303)

AutocorTest(log(1+as.numeric(m.intc7303)), lag=12)

ArchTest(log(1+as.numeric(m.intc7303)), lag=12)

##
## sec. 3.4.  The ARCH model
##

# p. 103 
# Figure 3.2
data(exch.perc)
str(exch.perc)

op <- par(mfrow=c(2,1))
plot(exch.perc, type="l", xlab="", ylab="fx",
     main="(a) Percentage change in exchange rate")
plot(exch.perc^2, type="l", xlab="", ylab="sq-fx",
     main="(b) Squared series")
par(op)

# p. 104 
# Figure 3.3

op <- par(mfrow=c(2,1))
Acf(exch.perc, ylim=c(-.1, .1), main="(a) Sample ACF")

pacf(exch.perc^2, ylim=c(-.1, .1),
     main="(b) Partial ACF of the squared series")
par(op)

# sec. 3.4.1.  Properties of ARCH models   

# p. 106
# sec. 3.4.2.  Weaknesses of ARCH models

# sec. 3.4.3.  Building an ARCH model 

# p. 109
# sec. 3.4.4.  Some Examples

# Example 3.1
data(m.intc7303)
ml.intc <- log(1+m.intc7303)

# Possibiliities:
#garch {tseries} Fit GARCH Models to Time Series
#GarchFitting {fGarch} Univariate GARCH Time Series Fitting

library(tseries)
#arch3.fit <- garch(ml.intc, order=c(1, 3))
#Error in garch(ml.intc, order = c(1, 3)) : NAs in x

arch3.fit <- garch(as.numeric(ml.intc), order=c(1, 3))
summary(arch3.fit)
# very different from Tsay

##??????????????
##
## Question sent to a package maintainer.  20007.12.24
##
##??????????????

library(fGarch)
#arch3.Fit <- garchFit(~garch(3, 0), data=ml.intc)

##??????????????
##
## Question sent to a package maintainer.  2007.12.24
##
##??????????????

# p. 112
# Figure 3.4
# plot of residuals from a fit that I don't know yet how to get


# p. 113 
##
## sec. 3.5.  The GARCH Model
##

# p. 116
#  sec. 3.5.1.  An Illustrative Example
data(sp500)

(spFit03 <- arima(sp500, c(0, 0, 3)))
coef(spFit03)
# not great:  Force ma2 = 0 
(spFit03. <- arima(sp500, c(0, 0, 3),
                 fixed=c(ma1=NA, ma2=0, ma3=NA, intercept=NA)))
names(spFit03.)
sqrt(spFit03.$sigma2)

str(sp500)
(spFit30 <- arima(sp500, c(3, 0, 0)))

library(fGarch)
spFit30.11 <- garchFit(sp500~arma(3,0)+garch(1,1),
                       data=sp500)
spFit30.11
# Difference from the book could be minor differences in
# the accuracy of the nonlinear optimizer used.  

# p. 117

# Figure 3.5
plot(sp500, xlab="year", ylab="rtn")
abline(h=0, lty="dashed")

# Figure 3.6 
op <- par(mfrow=c(2,1))
Acf(sp500, lag.max=30, main="(a)")
pacf(sp500^2, main="(b)")
par(op)

# p. 118
# unconditional var(a[t]) =
#str(spFit30.11)
with(spFit30.11@fit, par["omega"]/(1-par["beta1"]-par["alpha1"]))
# Differs from the book by 10%
# ... within the numeric precision of available
# algorithms for this type of problem?  

# Drop insignificant terms and refit:  

spFit00.11 <- garchFit(sp500~garch(1,1), data=sp500)
spFit00.11
# unconditional var(a[t]) =
with(spFit00.11@fit, par["omega"]/(1-par["beta1"]-par["alpha1"]))
# again within 10%

str(spFit00.11)

# Figure 3.7 
op <- par(mfrow=c(2,1))
plot(index(sp500), spFit00.11@sigma.t, type="l", xlab="year",
     ylab="sigma.t", main="(a) Estimated volatility process")
std.res <- residuals(spFit00.11)/spFit00.11@sigma.t
plot(index(sp500), std.res, type="l", xlab="year",
     ylab="std-resi", main="(b) Standardized residuals")
par(op)

# p. 119
# Figure 3.8
op <- par(mfrow=c(2,1))
Acf(std.res, ylim=c(-.2, .2), main="(a)", lag.max=24)
Acf(std.res^2, ylim=c(-.2, .2), main="(b)", lag.max=24)
par(op)

AutocorTest(std.res, 12)
AutocorTest(std.res, 24)

AutocorTest(std.res^2, 12)
AutocorTest(std.res^2, 24)

# p. 120
# Since the 'arma' part of the model is nothing,
# the "mean return" forecast is constant 'mu',
# estimated here as 0.0074497 vs. 0.0076 in the book.  
#str(spFit00.11)
names(spFit00.11@fit)
spFit00.11@fit$coef['mu']

pred.spFit00.11 <- predict(spFit00.11, 1000)

plot(pred.spFit00.11[, "standardDeviation"])
pred.spFit00.11[c(1:5, 1000), -2]

# Moderately close to Table 3.1  

# *** Can garchFit be used with assumed Student's t shocks?

# p. 121
# sec. 3.5.2.  Forecasting evaluation

# sec. 3.5.3.  A two-pass estimation method

mean(sp500)
# 0.006143

sp500a <- sp500-mean(sp500)

(sp500a1.1 <- arima(sp500a^2, c(1,0,1)))

coef(sp500a1.1)

(beta.1 <- (-coef(sp500a1.1)[2]))
(alpha.1 <- sum(coef(sp500a1.1)[1:2]))

# p. 122
##
## 3.6.  The Integrated GARCH model
##

# How to estimate IGARCH?


# p. 123
##
## 3.7.  The GARCH-M model
##

# How to estimate GARCH-M?


# p. 124
##
## 3.8.  The exponential GARCH model
##






