% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITRDB_FUNCTIONS.R
\name{download_itrdb}
\alias{download_itrdb}
\title{Download the latest version of the ITRDB.}
\usage{
download_itrdb(
  raw.dir = paste0(tempdir(), "/FedData/raw/itrdb"),
  force.redo = FALSE
)
}
\arguments{
\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to './RAW/ITRDB/'.}

\item{force.redo}{If a download already exists, should a new one be created? Defaults to FALSE.}
}
\value{
A data.table containing all of the ITRDB data.
}
\description{
Downloads and parses the latest zipped (numbered) version of the ITRDB.
This function includes improvements to the \code{\link{read_crn}} function from the
\pkg{dplR} library. The principle changes are better parsing of metadata, and support
for the Schweingruber-type Tucson format. Chronologies that are unable to be read
are reported to the user.
}
\keyword{internal}
