% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UTILITY_FUNCTIONS.R
\name{download_data}
\alias{download_data}
\title{Use curl to download a file.}
\usage{
download_data(
  url,
  destdir = getwd(),
  timestamping = TRUE,
  nc = FALSE,
  verbose = FALSE,
  progress = FALSE
)
}
\arguments{
\item{url}{The location of a file.}

\item{destdir}{Where the file should be downloaded to.}

\item{timestamping}{Should only newer files be downloaded?}

\item{nc}{Should files of the same type not be clobbered?}

\item{verbose}{Should cURL output be shown?}

\item{progress}{Should a progress bar be shown with cURL output?}
}
\value{
A character string of the file path to the downloaded file.
}
\description{
This function makes it easy to implement timestamping and no-clobber of files.
}
\details{
If both \code{timestamping} and \code{nc} are TRUE, nc behavior trumps timestamping.
}
\keyword{internal}
