% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAYMET_FUNCTIONS.R
\name{get_daymet}
\alias{get_daymet}
\title{Download and crop the 1-km DAYMET daily weather dataset.}
\usage{
get_daymet(template, label, elements = NULL, years = NULL,
  raw.dir = "./RAW/DAYMET", extraction.dir = paste0("./EXTRACTIONS/", label,
  "/DAYMET"), force.redo = F)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve
as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{elements}{A character vector of elemets to extract.\cr
The available elements are:\cr
dayl = Duration of the daylight period in seconds per day. This calculation is based on the period of the day during which the sun is above a hypothetical flat horizon.\cr
prcp = Daily total precipitation in millimeters per day, sum of all forms converted to water-equivalent. Precipitation occurrence on any given day may be ascertained.\cr
srad = Incident shortwave radiation flux density in watts per square meter, taken as an average over the daylight period of the day. NOTE: Daily total radiation (MJ/m2/day) can be calculated as follows: ((srad (W/m2) * dayl (s/day)) / l,000,000)\cr
swe = Snow water equivalent in kilograms per square meter. The amount of water contained within the snowpack.\cr
tmax = Daily maximum 2-meter air temperature in degrees Celsius.\cr
tmin = Daily minimum 2-meter air temperature in degrees Celsius.\cr
vp = Water vapor pressure in pascals. Daily average partial pressure of water vapor.\cr}

\item{years}{A numeric vector of years to extract.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to './RAW/DAYMET/'.}

\item{extraction.dir}{A character string indicating where the extracted and cropped DEM should be put.
The directory will be created if missing. Defaults to './EXTRACTIONS/DAYMET/'.}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created?}
}
\value{
A named list of \code{RasterBrick}s of weather data cropped to the extent of the template.
}
\description{
\code{get_daymet} returns a \code{RasterBrick} of weather data cropped to a given
template study area.
}
\examples{
\dontrun{
# Extract data for the Village Ecodynamics Project 'VEPIIN' study area:
# http://village.anth.wsu.edu
vepPolygon <- polygon_from_extent(raster::extent(672800,740000,4102000,4170000),
     proj4string='+proj=utm +datum=NAD83 +zone=12')

# Get the DAYMET (North America only)
# Returns a list of raster bricks
DAYMET <- get_daymet(template=vepPolygon,
                     label='VEPIIN',
                     elements = c('prcp','tmin','tmax'),
                     years = 1980:1985)

# Plot with raster::plot
plot(DAYMET$tmin$X1985.10.23)
}
}
