% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GHCN_FUNCTIONS.R
\name{getGHCNDaily}
\alias{getGHCNDaily}
\title{Download and crop the Global Historical Climate Network-Daily data.}
\usage{
getGHCNDaily(template = NULL, label = NULL, elements = NULL,
  raw.dir = "./RAW/GHCN/", extraction.dir = "./EXTRACTIONS/GHCN/",
  standardize = F, force.redo = F)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve
as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{elements}{A character vector of elemets to extract.
Common elements include "tmin", "tmax", and "prcp".}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to "./RAW/GHCN/".}

\item{extraction.dir}{A character string indicating where the extracted and cropped GHCN shapefiles should be put.
The directory will be created if missing. Defaults to "./EXTRACTIONS/GHCN/".}

\item{standardize}{Select only common year/month/day? Defaults to FALSE.}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created? Defaults to FALSE.}
}
\value{
A named list containing the "spatial" and "tabular" data.
}
\description{
\code{getGHCNDaily} returns a named list of length 2:
\enumerate{
\item "spatial": A \code{SpatialPointsDataFrame} of the locations of GHCN weather stations
in the template, and
\item "tabular": A named list of \code{\link{data.frame}s} with the daily weather data for each station.
The name of each list item is the station ID.
}
}

