% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_data.R
\name{getDSdata}
\alias{getDSdata}
\title{Get DS Dataset}
\usage{
getDSdata()
}
\description{
A function to extract the log-returns 
of 16 financial series and time series provided by the packages \code{datasets} 
(EuStockMarkets, sunspot.year) and \code{timeSeries} (USDCHF, MSFT, LPP2005REC).
The 16 datasets are converted to a list of numeric without any reference 
to the original dates. This list is usually called \code{DS}, hence the name.
}
\details{
The dataset is usually created by the instruction \code{DS <- getDSdata()}.
Then, it is used with a call to DS[[j]] with j in 1:16. 
\enumerate{
  \item{ "USDCHF" (USDCHF, timeSeries) }
  \item{ "MSFT" (MSFT, timeSeries) }
  \item{ "DAX" (EuStockMarkets, datasets) }
  \item{ "SMI" (EuStockMarkets, datasets) }
  \item{ "CAC" (EuStockMarkets, datasets) }
  \item{ "FTSE" (EuStockMarkets, datasets) }
  \item{ "SBI" (LPP2005REC, timeSeries) }
  \item{ "SPI" (LPP2005REC, timeSeries) }
  \item{ "SII" (LPP2005REC, timeSeries) }
  \item{ "LMI" (LPP2005REC, timeSeries) }
  \item{ "MPI" (LPP2005REC, timeSeries) }
  \item{ "ALT" (LPP2005REC, timeSeries) }
  \item{ "LPP25" (LPP2005REC, timeSeries) }
  \item{ "LPP40" (LPP2005REC, timeSeries) }
  \item{ "LPP60" (LPP2005REC, timeSeries) }
  \item{ "sunspot" (sunspot.year, datasets) }
}
Note that \code{sunspot.year} is regularly updated with each new version of  
\code{R}. The generated dataset is \code{logreturn(sunspot.year + 1000)}.
}
\examples{
   

require(timeSeries) 

getDSdata
DS  <- getDSdata()
attributes(DS)
sapply(DS, length)
sapply(DS, head)

}
\seealso{
\code{\link[datasets]{EuStockMarkets}}, \code{\link[datasets]{sunspot.year}}, 
\code{\link[timeSeries]{TimeSeriesData}}, \code{\link{regkienerLX}}, 
\code{\link{fitkienerX}}
}
